/*
 * Copyright (C) 1998,1999,2000,2001 Nikos Mavroyanopoulos
 * 
 * This library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "../../lib/libdefs.h"
#include "../../lib/mcrypt_modules.h"

#ifdef USE_LTDL
#define _init_mcrypt nofb_LTX__init_mcrypt
#define _mcrypt_set_state nofb_LTX__mcrypt_set_state
#define _end_mcrypt nofb_LTX__end_mcrypt
#define _mcrypt nofb_LTX__mcrypt
#define _mdecrypt nofb_LTX__mdecrypt
#define _has_iv nofb_LTX__has_iv
#define _is_block_mode nofb_LTX__is_block_mode
#define _is_block_algorithm_mode nofb_LTX__is_block_algorithm_mode
#define _mcrypt_get_modes_name nofb_LTX__mcrypt_get_modes_name
#define _mcrypt_mode_get_size nofb_LTX__mcrypt_mode_get_size
#define _mcrypt_mode_version nofb_LTX__mcrypt_mode_version
#endif

typedef struct nofb_buf {
	byte* sd_register;
	byte* s_register;
	byte* enc_s_register;
	byte* enc_sd_register;
} nOFB_BUFFER;

/* nOFB MODE */

int _init_mcrypt( nOFB_BUFFER* buf, void *key, int lenofkey, void *IV, int size)
{
/* For ofb */
	buf->sd_register=malloc( size);
	buf->s_register=malloc( size);
	buf->enc_s_register=malloc( size);
	buf->enc_sd_register=malloc( size);
	if (IV!=NULL) {
		memmove(buf->sd_register, IV, size);
		memmove(buf->s_register, IV, size);
	} else {
		memset(buf->sd_register, 0, size);
		memset(buf->s_register, 0, size);
	}

/* End ofb */

	return 0;

}

int _mcrypt_set_state( nOFB_BUFFER* buf, void *IV, int size)
{
	memmove(buf->enc_s_register, IV, size);
	memmove(buf->enc_sd_register, IV, size);
	memmove(buf->sd_register, IV, size);
	memmove(buf->s_register, IV, size);

	return 0;
}


void _end_mcrypt( nOFB_BUFFER* buf) {
	free(buf->sd_register);
	free(buf->s_register);
	free(buf->enc_sd_register);
	free(buf->enc_s_register);
}


int _mcrypt( nOFB_BUFFER* buf,void *plaintext, int len, int blocksize, void* akey, void (*func)(void*,void*), void (*func2)(void*,void*))
{				/* plaintext is n*blocksize bytes (nbit ofb) */
	word32 *plain, *fplain = plaintext;
	int i, j;
	void (*_mcrypt_block_encrypt) (void *, void *);

	_mcrypt_block_encrypt = func;


	for (j = 0; j < len / blocksize; j++) {
		plain = &fplain[j * blocksize / sizeof(word32)];
		memmove(buf->enc_s_register, buf->s_register, blocksize);
		_mcrypt_block_encrypt(akey, buf->enc_s_register);

		for (i = 0; i < blocksize / sizeof(word32); i++) {
			plain[i] ^=
			    ((word32 *) &
			     buf->enc_s_register[0 +
						i * sizeof(word32)])[0];
		}
/* Put the new register */
		memmove(buf->s_register, buf->enc_s_register, blocksize);
	}
	if (j==0 && len!=0) return -1;
	return 0;
}


int _mdecrypt( nOFB_BUFFER* buf, void *plaintext, int len, int blocksize, void* akey, void (*func)(void*,void*), void (*func2)(void*,void*))
{				/* plaintext is n bytes (nbit ofb) */
	word32 *plain, *fplain = plaintext;
	int i, j;
	void (*_mcrypt_block_encrypt) (void *, void *);

	_mcrypt_block_encrypt = func;


	for (j = 0; j < len / blocksize; j++) {
		plain = &fplain[j * blocksize / sizeof(word32)];
		memmove(buf->enc_sd_register, buf->sd_register, blocksize);
		_mcrypt_block_encrypt(akey, buf->enc_sd_register);

/* Shift the register */
		memmove(buf->sd_register, buf->enc_sd_register, blocksize);

		for (i = 0; i < blocksize / sizeof(word32); i++) {
			plain[i] ^=
			    ((word32 *) &
			     buf->enc_sd_register[0 +  i * sizeof(word32)])[0];
		}
	}
	if (j==0 && len!=0) return -1;
	return 0;
}

int _has_iv() { return 1; }
int _is_block_mode() { return 1; }
int _is_block_algorithm_mode() { return 1; }
char *_mcrypt_get_modes_name() { char*x; x=malloc(10); strcpy(x, "nOFB"); return x;}
int _mcrypt_mode_get_size () {return sizeof(nOFB_BUFFER);}


word32 _mcrypt_mode_version() {
	return 20010201;
}
