/* Copyright (C) 1998,1999 Nikos Mavroyanopoulos
 * This library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* modified in order to use the libmcrypt API by Nikos Mavroyanopoulos 
 * All modifications are placed under the license of libmcrypt.
 */

#include "../../lib/libdefs.h"
#include "../../lib/mcrypt_modules.h"
#include <stdlib.h>
#include "arcfour-iv.h"

#ifdef USE_LTDL
#define _mcrypt_set_key arcfour_iv_LTX__mcrypt_set_key
#define _mcrypt_encrypt arcfour_iv_LTX__mcrypt_encrypt
#define _mcrypt_decrypt arcfour_iv_LTX__mcrypt_decrypt
#define _mcrypt_get_size arcfour_iv_LTX__mcrypt_get_size
#define _mcrypt_get_block_size arcfour_iv_LTX__mcrypt_get_block_size
#define _is_block_algorithm arcfour_iv_LTX__is_block_algorithm
#define _mcrypt_get_key_size arcfour_iv_LTX__mcrypt_get_key_size
#define _mcrypt_get_algo_iv_size arcfour_iv_LTX__mcrypt_get_algo_iv_size
#define _mcrypt_get_supported_key_sizes arcfour_iv_LTX__mcrypt_get_supported_key_sizes
#define _mcrypt_get_algorithms_name arcfour_iv_LTX__mcrypt_get_algorithms_name
#define _mcrypt_self_test arcfour_iv_LTX__mcrypt_self_test
#define _mcrypt_algorithm_version arcfour_iv_LTX__mcrypt_algorithm_version
#endif

/* The IV option is a libmcrypt extension. In order to be compatible with
 * other implementations initialize it as NULL and it's size as 0.
 */

#define swap_byte(x,y) t = *(x); *(x) = *(y); *(y) = t

WIN32DLL_DEFINE
void _mcrypt_set_key(arcfour_key *key, word8 *key_data_ptr, int key_data_len, char* IV, int ivlen)
{
  word8 t;
  word8 index1;
  word8 index2;
  word8* state;
  short counter;
  word8 ivindex;

  state = key->state;
  
  for(counter = 0; counter < 256; counter++)
	  state[counter] = counter;
  key->x = 0;
  key->y = 0;
  index1 = 0;
  index2 = 0;
  ivindex = 0;

  for(counter = 0; counter < 256; counter++)  {
	if (ivlen>0) {
		index2 = ( IV[ivindex] + key_data_ptr[index1] + state[counter] + index2) % 256;
	} else {
		index2 = ( key_data_ptr[index1] + state[counter] + index2) % 256;
	}
	swap_byte(&state[counter], &state[index2]);
	index1 = (index1 + 1) % key_data_len;
	if (ivlen>0) ivindex = (ivindex+1) % ivlen;
  }

}

WIN32DLL_DEFINE
void _mcrypt_encrypt(arcfour_key *key, word8 *buffer_ptr, int buffer_len)
{
  word8 t;
  word8 x;
  word8 y;
  word8* state;
  word8 xorIndex;
  short counter;

  x = key->x;
  y = key->y;
  state = &key->state[0];
  for(counter = 0; counter < buffer_len; counter++)
  {
    x = (x + 1) % 256;
    y = (state[x] + y) % 256;
    swap_byte(&state[x], &state[y]);
    xorIndex = (state[x] + state[y]) % 256;
    buffer_ptr[counter] ^= state[xorIndex];
  }
  key->x = x;
  key->y = y;
}

WIN32DLL_DEFINE
void _mcrypt_decrypt(arcfour_key *key, word8 *buffer_ptr, int buffer_len)
{
  word8 t;
  word8 x;
  word8 y;
  word8* state;
  word8 xorIndex;
  short counter;

  x = key->x;
  y = key->y;
  state = &key->state[0];
  for(counter = 0; counter < buffer_len; counter++)
  {
    x = (x + 1) % 256;
    y = (state[x] + y) % 256;
    swap_byte(&state[x], &state[y]);
    xorIndex = (state[x] + state[y]) % 256;
    buffer_ptr[counter] ^= state[xorIndex];
  }
  key->x = x;
  key->y = y;
}


WIN32DLL_DEFINE
int _mcrypt_get_size () {return sizeof(arcfour_key);}
WIN32DLL_DEFINE
int _mcrypt_get_block_size() { return 1; }
WIN32DLL_DEFINE
int _mcrypt_get_algo_iv_size() { return 32; }
WIN32DLL_DEFINE
int _is_block_algorithm() { return 0; }
WIN32DLL_DEFINE
int _mcrypt_get_key_size() { return 256; }
WIN32DLL_DEFINE
int* _mcrypt_get_supported_key_sizes(int *len) {
	*len=0;
	return NULL;
}
WIN32DLL_DEFINE
char * _mcrypt_get_algorithms_name() { char*x; x=malloc(5); strcpy(x, "RC4"); return x;}

#define CIPHER "3abaa03a286e24c4196d292ab72934d6854c3eee"

WIN32DLL_DEFINE
int _mcrypt_self_test() {
	char *keyword;
	unsigned char *plaintext;
        unsigned char *ciphertext;
        int blocksize=20, j;
        void *key;
        unsigned char cipher_tmp[200];
                         
	keyword = calloc(1, _mcrypt_get_key_size());
        for (j=0; j< _mcrypt_get_key_size(); j++) {
	        keyword[j]=((j*2+10)%256);
	}
	ciphertext = malloc(blocksize);
        plaintext = malloc(blocksize);
        for (j=0; j< blocksize; j++) {
	        plaintext[j]=j%256;
	}
	key=malloc(_mcrypt_get_size());
	memcpy(ciphertext, plaintext, blocksize);

	_mcrypt_set_key( key, (void*)keyword, _mcrypt_get_key_size(), NULL, 0);
	_mcrypt_encrypt( key, (void*)ciphertext, blocksize);

        for (j = 0; j < blocksize; j++) {
               sprintf(&((char *) cipher_tmp)[2 * j], "%.2x",
               ciphertext[j]);
        }

	if (strcmp( (char*)cipher_tmp, CIPHER) != 0) {
	        printf("failed compatibility\n");
	        printf("Expected: %s\nGot: %s\n", CIPHER, (char*)cipher_tmp);
	        return -1;
	}

	_mcrypt_set_key( key, (void*)keyword, _mcrypt_get_key_size(), NULL, 0);
	_mcrypt_decrypt( key, (void*)ciphertext,  blocksize);

	if (strcmp( ciphertext, plaintext) != 0) {
	        printf("failed internally\n");
	        return -1;
	}
	return 0;
}

WIN32DLL_DEFINE
word32 _mcrypt_algorithm_version() {
        return 19991210;
}

