#include "mhash.h"
#include "libdefs.h"
#include "keygen.h"


/* Key generation using any hash algorithm */
int _mhash_gen_key_mcrypt(hashid algorithm, void *keyword, int key_size, void *salt, int salt_size,
		  unsigned char *password, int plen)
{
	word8* key=calloc(1, key_size);
	word8 *digest=NULL;
	int size = key_size;
	MHASH td;
	word8 *cp = key, *cp0 = key;
	int salt_z = 0;		/* flag to be used when freeing salt[] */
	int block_size = mhash_get_block_size(algorithm);

	if (salt == NULL) {
		salt_z = 1;
	}
	
	while (1) {
		td = mhash_init(algorithm);
		if (td<0) return -1;
		
		if (salt_z == 0)
			mhash(td, salt, salt_size);
		mhash(td, password, plen);
		if (cp - cp0 > 0)
			mhash(td, cp0, cp - cp0);
		digest=mhash_end(td);
		
		if (size > block_size) {
			memmove(cp, digest, block_size);
			free(digest);
			size -= block_size;
			cp += block_size;
		} else {
			memmove(cp, digest, size);
			free(digest);
			break;
		}
	}
	memmove(keyword, key, key_size);
	free( key);
	return 0;
}


