## MTNetflixQueue
## Copyright Benjamin Trott 2002. Released under the Artistic License.

=head1 NAME

MTNetflixQueue - Display and format your Netflix Queue

=head1 USAGE

=over 4

=item 1. Drop netflix-queue.pl into your plugins directory.

=item 2. Get your Netflix session ID from your browser cookies.

Log in to Netflix through your browser.

Look for the value of the NetflixShopperId cookie in your
browser preferences, after logging in. You'll use that below
where it says <your session id>

=item 3. Use the <MTNetflixQueue> tags to display your queue.

For example:

    <MTNetflixQueue session_id="<your session ID>">
    <a href="<$MTNetflixQueueURL$>"><$MTNetflixQueueTitle$></a><br />
    </MTNetflixQueue>

Available tags are:

    <MTNetflixQueue>
    <$MTNetflixQueueTitle$>
    <$MTNetflixQueueURL$>
    <$MTNetflixQueueGenre$>
    <$MTNetflixQueueRating$>
    <$MTNetflixQueueAvailability$>

=cut


use strict;
use MT::Template::Context;
use LWP::UserAgent;
use HTTP::Cookies;

MT::Template::Context->add_container_tag('NetflixQueue', \&queue);
MT::Template::Context->add_tag('NetflixQueueURL', \&queue_info);
MT::Template::Context->add_tag('NetflixQueueTitle', \&queue_info);
MT::Template::Context->add_tag('NetflixQueueAvailability', \&queue_info);
MT::Template::Context->add_tag('NetflixQueueRating', \&queue_info);
MT::Template::Context->add_tag('NetflixQueueGenre', \&queue_info);

my $queue = 'http://www.netflix.com/Queue';

sub queue {
    my($ctx, $args) = @_;
    my $session_id = $args->{session_id};

    my $jar = HTTP::Cookies->new;
    $jar->set_cookie(0, 'NetflixShopperId', $session_id, '/', '.netflix.com');
    my $req = HTTP::Request->new(GET => $queue);
    $jar->add_cookie_header($req);
    my $ua = LWP::UserAgent->new;
    $ua->agent('NetflixWebServices/1.0');
    my $res = $ua->request($req);
    return $ctx->error("HTTP error: " . $res->status_line)
        unless $res->is_success;

    my $builder = $ctx->stash('builder');
    my $tokens = $ctx->stash('tokens');

    my $c = $res->content;
    my $out = '';
    while ($c =~ m!<tr height=33>(.*?)</tr>!sg) {
        my $rec = $1;
        my @rec = $rec =~ m!<td height=33[^>]*>(.*?)</td>!sg;
        my($url, $title) = $rec[1] =~ m!<a href="?([^"]+)".*?>([^<]*)</a>!;
        $url =~ s!&trkid=(\d+)$!!;
        for (@rec[3,4,6]) {
        s!<.*?>!!g;
        }
        my $entry = { title => $title, url => $url, availability => $rec[6],
                      rating => $rec[4], genre => $rec[3] };
        $ctx->stash('netflix_queue_entry', $entry);
        defined(my $o = $builder->build($ctx, $tokens))
            or return $ctx->error($builder->errstr);
        $out .= $o;
    }
    $out;
}

sub queue_info {
    my $n = $_[0]->stash('netflix_queue_entry');
    (my $tag = lc $_[0]->stash('tag')) =~ s!^netflixqueue!!;
    $n->{$tag};
}

1;
