/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Netscape security libraries.
 * 
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are 
 * Copyright (C) 1994-2000 Netscape Communications Corporation.  All
 * Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */
/*
    Include file for libnls related utilities. Separated because there
    are a lot of headers for libnls, and only those objects which override
    the default Print function (see resource.h) should be including
    these files.

    mwelch - 1999 January
 */

#ifndef __nlsutil_h__
#define __nlsutil_h__

#include "resource.h"
#include "minihttp.h"

/* Macros */
#define NLS_RESULT_OK(rv) ()
/* Convenience typecasts. */

/* Clear a UnicodeString. */
void SSMTextGen_UTF8StringClear(char **str);

PRInt32 SSMTextGen_atoi();

SSMStatus SSMTextGen_PRTimeToUTF8String();

#ifdef DEBUG
void SSM_DebugUTF8String(char *prefix, char *ustr);
#else
#define SSM_DebugUTF8String(p,u) 
#endif

SSMStatus SSM_ConcatenateUTF8String(char **prefix, char *suffix);
#endif
