/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Netscape security libraries.
 * 
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are 
 * Copyright (C) 1994-2000 Netscape Communications Corporation.  All
 * Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */
#ifndef __SSM_P7CINFO_H__
#define __SSM_P7CINFO_H__

#include "secpkcs7.h"
#include "resource.h"
#include "certres.h"

/*
  Wrapper for the SEC_PKCS7ContentInfo structure. This is generated by
  several calls within the PKCS7 library, including PKCS7 decoder streams.
 */
typedef struct SSMP7ContentInfo
{
    SSMResource super;

    SEC_PKCS7ContentInfo *m_cinfo;
    SSMResourceCert *m_signerCert;
} SSMP7ContentInfo;

SSMStatus SSMP7ContentInfo_Create(void *arg, SSMControlConnection * conn, 
                                 SSMResource **res);
SSMStatus SSMP7ContentInfo_Init(SSMP7ContentInfo *ss, 
			       SSMControlConnection * conn,
			       SEC_PKCS7ContentInfo *cinfo, 
			       SSMResourceType type);
SSMStatus SSMP7ContentInfo_Destroy(SSMResource *res, PRBool doFree);
void SSMP7ContentInfo_Invariant(SSMP7ContentInfo *ss);

SSMStatus SSMP7ContentInfo_GetAttrIDs(SSMResource *res,
									 SSMAttributeID **ids,
									 PRIntn *count);

SSMStatus SSMP7ContentInfo_GetAttr(SSMResource *res,
                                   SSMAttributeID attrID,
                                   SSMResourceAttrType attrType,
                                   SSMAttributeValue *value);

/* 
   Functions which involve a PKCS7ContentInfo resource, but which
   aren't immediately germane to the object itself (if that makes
   sense) 
*/
SSMStatus SSMP7ContentInfo_VerifyDetachedSignature(SSMP7ContentInfo *ci,
												  SECCertUsage usage,
												  HASH_HashType hash,
												  PRBool keepCerts,
												  PRIntn digestLen,
												  char *detachedDigest);
												  

#endif
