/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Netscape security libraries.
 * 
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are 
 * Copyright (C) 1994-2000 Netscape Communications Corporation.  All
 * Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */
#ifndef PROCESSMSG_H_
#define PROCESSMSG_H_

SSMStatus
SSMControlConnection_ProcessDecodeAndCreateTempCert(SSMControlConnection * ctrl,
                                                    SECItem * msg);
SSMStatus
SSMControlConnection_ProcessDestroyCert(SSMControlConnection * ctrl,
                                        SECItem * msg);
SSMStatus
SSMControlConnection_ProcessGetKeyChoiceList(SSMControlConnection * ctrl, 
		     SECItem * msg);

/* This function runs on a separate thread and has a single argument */
typedef struct {
SSMControlConnection * ctrl;
SECItem * msg;
} genKeyArg;
void
SSMControlConnection_ProcessGenKeyOldStyle(void * arg); 
SSMStatus
SSMControlConnection_ProcessDecodeCertRequest(SSMControlConnection * ctrl,
                                              SECItem * msg);
SSMStatus
SSMControlConnection_ProcessFindCertByNickname(SSMControlConnection *ctrl, SECItem *msg);

SSMStatus
SSMControlConnection_ProcessFindCertByKey(SSMControlConnection *ctrl, SECItem *msg);

SSMStatus
SSMControlConnection_ProcessFindCertByEmailAddr(SSMControlConnection *ctrl, SECItem *msg);

SSMStatus
SSMControlConnection_ProcessAddCertToDB(SSMControlConnection *ctrl, SECItem *msg);

SSMStatus
SSMControlConnection_ProcessMatchUserCert(SSMControlConnection *ctrl, SECItem *msg);

SSMStatus SSMControlConnection_ProcessPickleSecurityStatusRequest(SSMControlConnection* ctrl,
								 SECItem* msg);

SSMStatus
SSMControlConnection_ProcessLocalizedTextRequest(SSMControlConnection *ctrl,
                                                 SECItem * msg);

SSMStatus
SSMControlConnection_ProcessRedirectCompare(SSMControlConnection *ctrl, 
					    SECItem * msg);

SSMStatus
SSMControlConnection_ProcessDecodeCRLRequest(SSMControlConnection *ctrl, 
					     SECItem *msg);


PRStatus 
SSMControlConnection_ProcessSecurityAdvsiorRequest(SSMControlConnection *ctrl, 
						   SECItem *msg);

SSMStatus
SSMControlConnection_ProcessGetExtensionRequest(SSMControlConnection *ctrl, 
                                                SECItem              *msg);

SSMStatus
SSMControlConnection_ProcessHTMLCertInfoRequest(SSMControlConnection *ctrl, 
						SECItem              *msg);
#endif /*PROCESSMSG_H_*/
