/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.rmi;

import de.tu_darmstadt.sp.rmi.RMISSLServerSocketFactory;
import de.tu_darmstadt.sp.rmi.RMISSLSocketFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;

public class RMISecureSocketFactory
extends RMISocketFactory {
    protected RMISSLSocketFactory clientFactory = new RMISSLSocketFactory();
    protected RMISSLServerSocketFactory serverFactory;

    public RMISecureSocketFactory() {
        String idReq = System.getProperty("de.tu_darmstadt.sp.ssl.clientIdentityRequired");
        System.setProperty("de.tu_darmstadt.sp.ssl.clientIdentityRequired", "true");
        this.serverFactory = new RMISSLServerSocketFactory();
        if (idReq != null) {
            System.setProperty("de.tu_darmstadt.sp.ssl.clientIdentityRequired", idReq);
        } else {
            System.setProperty("de.tu_darmstadt.sp.ssl.clientIdentityRequired", "false");
        }
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.serverFactory.createServerSocket(port);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.clientFactory.createSocket(host, port);
    }

    public static SSLSocket getClient() {
        return RMISSLServerSocketFactory.getClient();
    }

    public static X509Certificate getClientCertificate() throws SSLPeerUnverifiedException {
        return RMISSLServerSocketFactory.getClientCertificate();
    }

    public static X509Certificate[] getClientCertificateChain() throws SSLPeerUnverifiedException {
        return RMISSLServerSocketFactory.getClientCertificateChain();
    }

    public static SSLSocket getServer() {
        return RMISSLSocketFactory.getServer();
    }

    public static X509Certificate getServerCertificate() throws SSLPeerUnverifiedException {
        return RMISSLSocketFactory.getServerCertificate();
    }

    public static X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        return RMISSLSocketFactory.getServerCertificateChain();
    }
}

