/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.ssl;

import de.tu_darmstadt.sp.ssl.SSLeayHandle;
import de.tu_darmstadt.sp.ssl.SSLeayHandshakeCompletedEvent;
import de.tu_darmstadt.sp.ssl.SSLeayInputStream;
import de.tu_darmstadt.sp.ssl.SSLeayOutputStream;
import de.tu_darmstadt.sp.ssl.SSLeayRuntimeException;
import de.tu_darmstadt.sp.ssl.SSLeaySessionContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class SSLeaySocket
extends SSLSocket {
    protected SSLeayHandle handle = null;
    protected SSLeaySessionContext context = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean useClientMode = true;
    private boolean needClientAuth = true;
    private Vector listeners = null;
    private boolean enableSessionCreation = true;
    private boolean handshakeStarted = false;

    public SSLeaySocket(SSLeaySessionContext ctx) {
        if (ctx == null) {
            return;
        }
        this.useClientMode = true;
        this.listeners = new Vector();
        this.context = ctx;
        try {
            this.setupHandle();
        }
        catch (IOException e) {
            throw new SSLeayRuntimeException(e.getMessage());
        }
    }

    public SSLeaySocket(String host, int port, SSLeaySessionContext ctx) throws UnknownHostException, IOException {
        this(InetAddress.getByName(host), port, ctx);
    }

    public SSLeaySocket(String host, int port, InetAddress clientAddr, int clientPort, SSLeaySessionContext ctx) throws IOException {
        this(InetAddress.getByName(host), port, clientAddr, clientPort, ctx);
    }

    public SSLeaySocket(InetAddress address, int port, SSLeaySessionContext ctx) throws IOException {
        this(address, port, null, 0, ctx);
    }

    protected SSLeaySocket(InetAddress address, int port, InetAddress clientAddr, int clientPort, SSLeaySessionContext ctx) throws IOException {
        super(address, port, clientAddr, clientPort);
        if (ctx == null) {
            throw new IllegalArgumentException("SSLeaySocket.init(): ctx is null");
        }
        this.context = ctx;
        this.setNeedClientAuth(true);
        this.setUseClientMode(true);
        this.listeners = new Vector();
        try {
            this.setupHandle();
        }
        catch (IOException e) {
            throw new SSLeayRuntimeException(e.getMessage());
        }
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(listener)) {
                Object var3_3 = null;
                return;
            }
            this.listeners.addElement(listener);
        }
    }

    public void close() throws IOException {
        this.handle.close();
        super.close();
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public String[] getEnabledCipherSuites() {
        return this.handle.getEnabledCipherSuites();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.handshakeStarted) {
            this.startHandshake();
        }
        if (this.in == null) {
            this.in = new SSLeayInputStream(this.handle);
        }
        return this.in;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.handshakeStarted) {
            this.startHandshake();
        }
        if (this.out == null) {
            this.out = new SSLeayOutputStream(this.handle);
        }
        return this.out;
    }

    public String getPeerName() throws SSLException {
        if (this.handle == null) {
            throw new SSLException("Handshake not performed");
        }
        return this.handle.getPeerDN();
    }

    public SSLSession getSession() {
        return this.handle.getSession();
    }

    public String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    private void notifyListeners() {
        SSLeayHandshakeCompletedEvent event = new SSLeayHandshakeCompletedEvent(this, this.getSession());
        Enumeration listenersEnum = this.listeners.elements();
        while (listenersEnum.hasMoreElements()) {
            HandshakeCompletedListener l = (HandshakeCompletedListener)listenersEnum.nextElement();
            l.handshakeCompleted(event);
        }
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(listener)) {
                Object var3_3 = null;
                return;
            }
            this.listeners.removeElement(listener);
        }
    }

    public void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    public void setEnabledCipherSuites(String[] ciphers) throws IllegalArgumentException {
        this.handle.setEnabledCipherSuites(ciphers);
    }

    public void setNeedClientAuth(boolean flag) {
        this.needClientAuth = flag;
    }

    public void setUseClientMode(boolean mode) {
        this.useClientMode = mode;
    }

    void setupHandle() throws IOException {
        if (this.handle != null) {
            return;
        }
        try {
            this.handle = new SSLeayHandle(this, this.context);
        }
        catch (SSLException e) {
            throw new IOException("SSL:" + e.getMessage());
        }
    }

    public synchronized void startHandshake() throws IOException, SSLException {
        if (!this.handshakeStarted) {
            this.handle.enableTransport();
        }
        this.handshakeStarted = true;
        try {
            if (this.getNeedClientAuth()) {
                this.handle.setVerificationPolicy(this.getUseClientMode(), this.getNeedClientAuth());
            }
            if (this.useClientMode) {
                this.handle.clientHandshake();
            } else {
                this.handle.serverHandshake();
            }
        }
        catch (SSLException e) {
            throw new IOException("SSL:" + e.getMessage());
        }
        this.notifyListeners();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\nSOCKET PARAMETERS\n\n");
        buf.append("Cipher suites enabled for this socket:\n  ");
        String[] eciphers = this.getEnabledCipherSuites();
        int i = 0;
        while (i < eciphers.length) {
            buf.append("\n" + eciphers[i]);
            ++i;
        }
        buf.append("\nSocket uses client mode (true/false):");
        buf.append(String.valueOf(this.getUseClientMode()) + "\n");
        buf.append("\nSocket requires peer authentication (true/false):");
        buf.append(String.valueOf(this.getNeedClientAuth()) + "\n");
        SSLSession sess = this.getSession();
        if (sess == null) {
            buf.append("\nSocket not connected (no sesion)\n");
        } else {
            buf.append("\nSESSION INFORMATION\n\n");
        }
        buf.append(sess.toString());
        return buf.toString();
    }
}

