/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.rmi;

import de.tu_darmstadt.sp.rmi.RMISSLSocket;
import de.tu_darmstadt.sp.ssl.SSLeayServerSocket;
import de.tu_darmstadt.sp.ssl.SSLeayServerSocketFactory;
import java.io.Serializable;
import java.rmi.server.RMIServerSocketFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class RMISSLServerSocketFactory
extends SSLeayServerSocketFactory
implements RMIServerSocketFactory,
Serializable {
    public RMISSLServerSocketFactory() {
        try {
            Class<?> sscls = Class.forName("de.tu_darmstadt.sp.rmi.RMISSLServerSocket");
            this.setServerSocketClass(sscls);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("RMISSLServerSocketFactory.init()");
        }
    }

    public static SSLSocket getClient() {
        return RMISSLSocket.getCurrentServerSideSocket();
    }

    public static X509Certificate getClientCertificate() throws SSLPeerUnverifiedException {
        X509Certificate[] peerCerts = RMISSLServerSocketFactory.getClientCertificateChain();
        return peerCerts[0];
    }

    public static X509Certificate[] getClientCertificateChain() throws SSLPeerUnverifiedException {
        SSLSocket sock = RMISSLServerSocketFactory.getClient();
        SSLSession sess = sock.getSession();
        return sess.getPeerCertificateChain();
    }

    protected void setSSLPolicy(SSLeayServerSocket s) {
        s.setNeedClientAuth(true);
    }
}

