/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.rmi;

import de.tu_darmstadt.sp.ssl.SSLeaySessionContext;
import de.tu_darmstadt.sp.ssl.SSLeaySocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.net.ssl.SSLSocket;

public class RMISSLSocket
extends SSLeaySocket {
    static Map incommingcns = Collections.synchronizedMap(new WeakHashMap());
    static Map outgoingcns = Collections.synchronizedMap(new WeakHashMap());

    public RMISSLSocket(SSLeaySessionContext ctx) {
        super(ctx);
    }

    public RMISSLSocket(String host, int port, SSLeaySessionContext ctx) throws UnknownHostException, IOException {
        super(host, port, ctx);
    }

    public RMISSLSocket(String host, int port, InetAddress clientAddr, int clientPort, SSLeaySessionContext ctx) throws IOException {
        super(host, port, clientAddr, clientPort, ctx);
    }

    public RMISSLSocket(InetAddress address, int port, SSLeaySessionContext ctx) throws IOException {
        super(address, port, ctx);
    }

    protected RMISSLSocket(InetAddress address, int port, InetAddress clientAddr, int clientPort, SSLeaySessionContext ctx) throws IOException {
        super(address, port, clientAddr, clientPort, ctx);
    }

    public static SSLSocket getCurrentClientSideSocket() {
        SSLSocket result = (SSLSocket)outgoingcns.get(Thread.currentThread());
        return result;
    }

    public static SSLSocket getCurrentServerSideSocket() {
        SSLSocket result = (SSLSocket)incommingcns.get(Thread.currentThread());
        return result;
    }

    public InputStream getInputStream() throws IOException {
        this.updateCurrentConnections();
        return super.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        this.updateCurrentConnections();
        return super.getOutputStream();
    }

    private void updateCurrentConnections() {
        if (this.getUseClientMode()) {
            outgoingcns.put(Thread.currentThread(), this);
        } else {
            incommingcns.put(Thread.currentThread(), this);
        }
    }
}

