/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.ssl;

import de.tu_darmstadt.sp.ssl.SSLeaySession;
import de.tu_darmstadt.sp.ssl.SSLeaySessionContext;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLException;

public class SSLeayHandle {
    private int connection;
    private Socket sock;
    private SSLeaySessionContext context;

    public SSLeayHandle(Socket sock, SSLeaySessionContext context) throws SSLException {
        this.context = context;
        this.sock = sock;
        this.setup();
    }

    native void clientHandshake() throws SSLException;

    native void close();

    native void doEnableTransport(Socket var1, int var2) throws SSLException;

    protected native int doGetSession();

    native void doSetEnabledCipherSuites(String var1);

    void enableTransport() throws SSLException {
        String java_version = System.getProperty("java.specification.version");
        int java_minor_version = java_version == null || !java_version.equals("1.2") ? 1 : 2;
        this.doEnableTransport(this.sock, java_minor_version);
    }

    public native String[] getEnabledCipherSuites();

    native String getPeerDN();

    public SSLeaySession getSession() {
        int opaque = this.doGetSession();
        return new SSLeaySession(opaque, this.context);
    }

    native int readBytes(byte[] var1, int var2, int var3) throws IOException, SSLException;

    native void serverHandshake() throws SSLException;

    public void setEnabledCipherSuites(String[] ciphers) {
        if (ciphers == null) {
            ciphers = this.context.getDefaultCipherSuites();
        }
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < ciphers.length) {
            if (i != 0) {
                strbuf.append(":");
            }
            strbuf.append(ciphers[i]);
            ++i;
        }
        this.doSetEnabledCipherSuites(strbuf.toString());
    }

    native void setVerificationPolicy(boolean var1, boolean var2);

    native void setup() throws SSLException;

    native void writeBytes(byte[] var1, int var2, int var3) throws IOException, SSLException;
}

