/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.ssl;

import de.tu_darmstadt.sp.ssl.SSLeaySessionContext;
import de.tu_darmstadt.sp.ssl.SSLeaySocket;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;

public class SSLeayServerSocket
extends SSLServerSocket {
    protected SSLeaySessionContext context;
    protected Class socketPrototypeClass;
    private boolean useClientMode = false;
    private boolean needClientAuth = false;
    private boolean enableSessionCreation = true;
    private String[] enabledCipherSuites = null;
    private boolean enableAcceptHandshake = true;

    public SSLeayServerSocket(int port, int backlog, SSLeaySessionContext ctx) throws IOException {
        this(port, backlog, null, ctx);
    }

    public SSLeayServerSocket(int port, int backlog, InetAddress bindAddr, SSLeaySessionContext ctx) throws IOException {
        super(port, backlog, bindAddr);
        if (ctx == null) {
            throw new IllegalArgumentException("SSLeayServerSocket.init:ctx is null");
        }
        this.context = ctx;
        this.enabledCipherSuites = ctx.getDefaultCipherSuites();
        this.enableSessionCreation = true;
        this.useClientMode = false;
        this.needClientAuth = false;
        this.setSocketPrototype(new SSLeaySocket(ctx));
    }

    public SSLeayServerSocket(int port, SSLeaySessionContext ctx) throws IOException {
        this(port, 50, null, ctx);
    }

    public Socket accept() throws IOException {
        Class[] paramTypes = new Class[]{this.context.getClass()};
        Object[] params = new Object[]{this.context};
        SSLeaySocket s = null;
        String errorMsg = "SSLeayServerSocket.accept():";
        try {
            s = (SSLeaySocket)this.socketPrototypeClass.getConstructor(paramTypes).newInstance(params);
        }
        catch (NoSuchMethodException e1) {
            throw new Error(String.valueOf(errorMsg) + e1.getMessage());
        }
        catch (InstantiationException e2) {
            throw new Error(String.valueOf(errorMsg) + e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            this.handleInvocationException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new Error(String.valueOf(errorMsg) + e4.getMessage());
        }
        super.implAccept(s);
        s.setUseClientMode(this.useClientMode);
        s.setNeedClientAuth(this.needClientAuth);
        s.setEnableSessionCreation(this.enableSessionCreation);
        s.setEnabledCipherSuites(this.enabledCipherSuites);
        if (this.enableAcceptHandshake) {
            s.startHandshake();
        }
        return s;
    }

    public boolean getEnabelAcceptHandshake() {
        return this.enableAcceptHandshake;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public Class getSocketPrototypeClass() {
        return this.socketPrototypeClass;
    }

    public String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    private void handleInvocationException(InvocationTargetException e) throws IOException {
        Throwable e1 = e.getTargetException();
        if (new IOException().getClass().isInstance(e1)) {
            throw (IOException)e1;
        }
        throw new Error(e1.getMessage());
    }

    public void setEnableAcceptHandshake(boolean flag) {
        this.enableAcceptHandshake = flag;
    }

    public void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    public void setEnabledCipherSuites(String[] ciphers) {
        this.enabledCipherSuites = ciphers;
    }

    public void setNeedClientAuth(boolean flag) {
        this.needClientAuth = flag;
    }

    protected void setSocketPrototype(SSLeaySocket proto) {
        if (proto == null) {
            throw new IllegalArgumentException("setSocketPrototype(null)");
        }
        this.socketPrototypeClass = proto.getClass();
    }

    public void setUseClientMode(boolean mode) {
        this.useClientMode = mode;
    }
}

