/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.ssl;

import de.tu_darmstadt.sp.ssl.SSLeayIdentityException;
import de.tu_darmstadt.sp.ssl.SSLeayRuntimeException;
import de.tu_darmstadt.sp.ssl.SSLeayServerSocket;
import de.tu_darmstadt.sp.ssl.SSLeaySessionContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;

public class SSLeayServerSocketFactory
extends SSLServerSocketFactory
implements Serializable {
    protected transient SSLeaySessionContext context;
    protected Class socketType;
    private boolean userIdentitySet = false;
    private Class STRING_CLASS;
    private Class CONTEXT_CLASS;
    private Class INETADDRESS_CLASS;

    public SSLeayServerSocketFactory() {
        try {
            this.STRING_CLASS = Class.forName("java.lang.String");
            this.CONTEXT_CLASS = Class.forName("de.tu_darmstadt.sp.ssl.SSLeaySessionContext");
            this.INETADDRESS_CLASS = Class.forName("java.net.InetAddress");
            this.socketType = Class.forName("de.tu_darmstadt.sp.ssl.SSLeayServerSocket");
        }
        catch (Exception e) {
            throw new Error("SSLeayServerSocketFactory.init():" + e.getMessage());
        }
    }

    public SSLeayServerSocketFactory(SSLeaySessionContext context) {
        try {
            this.STRING_CLASS = Class.forName("java.lang.String");
            this.CONTEXT_CLASS = Class.forName("de.tu_darmstadt.sp.ssl.SSLeaySessionContext");
            this.INETADDRESS_CLASS = Class.forName("java.net.InetAddress");
            this.socketType = Class.forName("de.tu_darmstadt.sp.ssl.SSLeayServerSocket");
        }
        catch (Exception e) {
            throw new Error("SSLeayServerSocketFactory.init(context):" + e.getMessage());
        }
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null in SSLeayFactory constructor");
        }
        this.context = context;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        this.initContext();
        this.setUserIdentity();
        Class[] paramTypes = new Class[]{Integer.TYPE, this.CONTEXT_CLASS};
        Object[] params = new Object[]{new Integer(port), this.context};
        SSLeayServerSocket s = null;
        String errorMsg = "SSLeayServerSocketFactory.createSeverSocket(int):";
        try {
            s = (SSLeayServerSocket)this.socketType.getConstructor(paramTypes).newInstance(params);
        }
        catch (NoSuchMethodException e1) {
            throw new Error(String.valueOf(errorMsg) + e1.getMessage());
        }
        catch (InstantiationException e2) {
            throw new Error(String.valueOf(errorMsg) + e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            this.handleInvocationException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new Error(String.valueOf(errorMsg) + e4.getMessage());
        }
        this.setSSLPolicy(s);
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        this.initContext();
        this.setUserIdentity();
        Class[] paramTypes = new Class[]{Integer.TYPE, Integer.TYPE, this.CONTEXT_CLASS};
        Object[] params = new Object[]{new Integer(port), new Integer(backlog), this.context};
        SSLeayServerSocket s = null;
        String errorMsg = "SSLeayServerSocketFactory.createSeverSocket(int,int,context):";
        try {
            s = (SSLeayServerSocket)this.socketType.getConstructor(paramTypes).newInstance(params);
        }
        catch (NoSuchMethodException e1) {
            throw new Error(String.valueOf(errorMsg) + e1.getMessage());
        }
        catch (InstantiationException e2) {
            throw new Error(String.valueOf(errorMsg) + e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            this.handleInvocationException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new Error(String.valueOf(errorMsg) + e4.getMessage());
        }
        this.setSSLPolicy(s);
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this.initContext();
        this.setUserIdentity();
        Class[] paramTypes = new Class[]{Integer.TYPE, Integer.TYPE, this.INETADDRESS_CLASS, this.CONTEXT_CLASS};
        Object[] params = new Object[]{new Integer(port), new Integer(backlog), bindAddr, this.context};
        SSLeayServerSocket s = null;
        String errorMsg = "SSLeayServerSocketFactory.createSeverSocket(int,int,InetAddr,ctx):";
        try {
            s = (SSLeayServerSocket)this.socketType.getConstructor(paramTypes).newInstance(params);
        }
        catch (NoSuchMethodException e1) {
            throw new Error(String.valueOf(errorMsg) + e1.getMessage());
        }
        catch (InstantiationException e2) {
            throw new Error(String.valueOf(errorMsg) + e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            this.handleInvocationException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new Error(String.valueOf(errorMsg) + e4.getMessage());
        }
        this.setSSLPolicy(s);
        return s;
    }

    public String[] getDefaultCipherSuites() {
        this.initContext();
        return this.context.getDefaultCipherSuites();
    }

    public Class getServerSocketClass() {
        return this.socketType;
    }

    public String[] getSupportedCipherSuites() {
        this.initContext();
        return this.context.getSupportedCipherSuites();
    }

    private void handleInvocationException(InvocationTargetException e) throws IOException {
        Throwable e1 = e.getTargetException();
        if (new IOException().getClass().isInstance(e1)) {
            throw (IOException)e1;
        }
        throw new Error(e1.getMessage());
    }

    private synchronized void initContext() {
        if (this.context != null) {
            return;
        }
        try {
            this.context = new SSLeaySessionContext();
        }
        catch (SSLException sSLException) {
            throw new SSLeayRuntimeException("Could not create context");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.context = null;
        this.userIdentitySet = false;
    }

    public void setDefaultCipherSuites(String[] ciphers) {
        this.initContext();
        this.context.setDefaultCipherSuites(ciphers);
    }

    protected void setSSLPolicy(SSLeayServerSocket s) {
    }

    protected synchronized void setServerSocketClass(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("setSocketPrototypeClass(null)");
        }
        this.socketType = cls;
    }

    private synchronized void setUserIdentity() throws SSLeayIdentityException {
        block3: {
            if (this.userIdentitySet) {
                return;
            }
            try {
                this.context.setUserIdentity();
            }
            catch (SSLeayIdentityException e2) {
                String idReq = System.getProperties().getProperty("iti.ssl.serverIdentityRequired", "true");
                if (idReq.equals("false")) break block3;
                throw e2;
            }
        }
        this.userIdentitySet = true;
    }
}

