/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.ssl;

import de.tu_darmstadt.sp.ssl.SSLeayIdentityException;
import de.tu_darmstadt.sp.ssl.SSLeaySession;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

public class SSLeaySessionContext
implements SSLSessionContext {
    protected int context;
    protected Hashtable sessionHash;

    static {
        System.loadLibrary("itissl");
    }

    public SSLeaySessionContext() throws SSLException {
        String cipher_list = System.getProperty("de.tu_darmstadt.sp.ssl.cipher_list");
        this.setup(cipher_list);
        String ca_file = System.getProperty("iti.ssl.ca_file");
        String ca_path = System.getProperty("iti.ssl.ca_path");
        try {
            this.addTrustedCACerts(ca_file, ca_path);
        }
        catch (IOException iOException) {}
        this.sessionHash = new Hashtable();
    }

    protected SSLeaySessionContext(int context) {
        this.context = context;
        this.sessionHash = new Hashtable();
    }

    public native void addTrustedCACerts(String var1, String var2) throws IOException;

    private native void cleanup();

    private native void doSetDefaultCiphers(String var1, int var2);

    protected native void doSetUserIdentity(String var1, String var2) throws SSLeayIdentityException;

    protected void finalize() {
        this.cleanup();
    }

    public native String[] getDefaultCipherSuites();

    public Enumeration getIds() {
        this.update();
        return new SessionIdEnumeration(this.sessionHash.keys());
    }

    public synchronized SSLSession getSession(byte[] sessionId) {
        SSLeaySession sess = (SSLeaySession)this.sessionHash.get(new SessionIdContainer(sessionId));
        return sess;
    }

    protected native int[] getSessionOpaquePointers();

    public native String[] getSupportedCipherSuites();

    public void setDefaultCipherSuites(String[] ciphers) {
        if (ciphers == null) {
            throw new IllegalArgumentException("null value for default ciphers");
        }
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < ciphers.length) {
            if (i != 0) {
                strbuf.append(":");
            }
            strbuf.append(ciphers[i]);
            ++i;
        }
        this.doSetDefaultCiphers(strbuf.toString(), ciphers.length);
    }

    public void setUserIdentity() throws SSLeayIdentityException {
        String cert_file = System.getProperty("iti.ssl.cert_file");
        String key_file = System.getProperty("iti.ssl.key_file");
        this.doSetUserIdentity(cert_file, key_file);
    }

    private native void setup(String var1) throws SSLException;

    public void update() {
        int[] opaques = this.getSessionOpaquePointers();
        Hashtable hashtable = this.sessionHash;
        synchronized (hashtable) {
            this.sessionHash.clear();
            int i = 0;
            while (i < opaques.length) {
                SSLeaySession sess = new SSLeaySession(opaques[i], this);
                this.sessionHash.put(new SessionIdContainer(sess.getId()), sess);
                ++i;
            }
        }
    }

    static class SessionIdEnumeration
    implements Enumeration {
        Enumeration scn;

        SessionIdEnumeration(Enumeration other) {
            this.scn = other;
        }

        public boolean hasMoreElements() {
            return this.scn.hasMoreElements();
        }

        public Object nextElement() {
            return ((SessionIdContainer)this.scn.nextElement()).getId();
        }
    }

    class SessionIdContainer {
        String stringId;
        byte[] byteId;

        SessionIdContainer(byte[] sid) {
            this.stringId = sid.toString();
            this.byteId = sid;
        }

        public boolean equals(Object other) {
            return this.stringId.equals(((SessionIdContainer)other).stringId);
        }

        public byte[] getId() {
            return this.byteId;
        }

        public int hashCode() {
            return this.stringId.hashCode();
        }
    }
}

