/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.ssl;

import de.tu_darmstadt.sp.ssl.SSLeayIdentityException;
import de.tu_darmstadt.sp.ssl.SSLeayRuntimeException;
import de.tu_darmstadt.sp.ssl.SSLeaySessionContext;
import de.tu_darmstadt.sp.ssl.SSLeaySocket;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLeaySocketFactory
extends SSLSocketFactory
implements Serializable {
    protected transient SSLeaySessionContext context;
    protected Class socketType;
    private boolean userIdentitySet = false;
    private Class STRING_CLASS;
    private Class CONTEXT_CLASS;
    private Class INETADDRESS_CLASS;

    public SSLeaySocketFactory() {
        try {
            this.STRING_CLASS = Class.forName("java.lang.String");
            this.CONTEXT_CLASS = Class.forName("de.tu_darmstadt.sp.ssl.SSLeaySessionContext");
            this.INETADDRESS_CLASS = Class.forName("java.net.InetAddress");
            this.socketType = Class.forName("de.tu_darmstadt.sp.ssl.SSLeaySocket");
        }
        catch (Exception e) {
            throw new Error("SSLeaySocketFactory.init():" + e.getMessage());
        }
        this.context = null;
        this.userIdentitySet = false;
    }

    public SSLeaySocketFactory(SSLeaySessionContext context) {
        try {
            this.STRING_CLASS = Class.forName("java.lang.String");
            this.CONTEXT_CLASS = Class.forName("de.tu_darmstadt.sp.ssl.SSLeaySessionContext");
            this.INETADDRESS_CLASS = Class.forName("java.net.InetAddress");
            this.socketType = Class.forName("de.tu_darmstadt.sp.ssl.SSLeaySocket");
        }
        catch (Exception e) {
            throw new Error("SSLeaySpcketFactory.init(context):" + e.getMessage());
        }
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null in SSLeayFactory constructor");
        }
        this.context = context;
        this.userIdentitySet = false;
    }

    public Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        this.initContext();
        this.setUserIdentity();
        Class[] paramTypes = new Class[]{this.STRING_CLASS, Integer.TYPE, this.CONTEXT_CLASS};
        Object[] params = new Object[]{host, new Integer(port), this.context};
        SSLeaySocket s = null;
        String errorMsg = "SSLeaySocketFactory.createSocket(String,int):";
        try {
            s = (SSLeaySocket)this.socketType.getConstructor(paramTypes).newInstance(params);
        }
        catch (NoSuchMethodException e1) {
            throw new Error(String.valueOf(errorMsg) + e1.getMessage());
        }
        catch (InstantiationException e2) {
            throw new Error(String.valueOf(errorMsg) + e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            this.handleInvocationException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new Error(String.valueOf(errorMsg) + e4.getMessage());
        }
        this.setSSLPolicy(s);
        return s;
    }

    public Socket createSocket(String host, int port, InetAddress clientAddr, int clientPort) throws IOException, UnknownHostException {
        this.initContext();
        this.setUserIdentity();
        Class[] paramTypes = new Class[]{this.STRING_CLASS, Integer.TYPE, this.INETADDRESS_CLASS, Integer.TYPE, this.CONTEXT_CLASS};
        Object[] params = new Object[]{host, new Integer(port), clientAddr, new Integer(clientPort), this.context};
        SSLeaySocket s = null;
        String errorMsg = "SSLeaySocketFactory.createSocket(String,int,InetAddress,int):";
        try {
            s = (SSLeaySocket)this.socketType.getConstructor(paramTypes).newInstance(params);
        }
        catch (NoSuchMethodException e1) {
            throw new Error(String.valueOf(errorMsg) + e1.getMessage());
        }
        catch (InstantiationException e2) {
            throw new Error(String.valueOf(errorMsg) + e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            this.handleInvocationException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new Error(String.valueOf(errorMsg) + e4.getMessage());
        }
        this.setSSLPolicy(s);
        return s;
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        this.initContext();
        this.setUserIdentity();
        Class[] paramTypes = new Class[]{this.INETADDRESS_CLASS, Integer.TYPE, this.CONTEXT_CLASS};
        Object[] params = new Object[]{address, new Integer(port), this.context};
        SSLeaySocket s = null;
        String errorMsg = "SSLeaySocketFactory.createSocket(InetAddress,Int):";
        try {
            s = (SSLeaySocket)this.socketType.getConstructor(paramTypes).newInstance(params);
        }
        catch (NoSuchMethodException e1) {
            throw new Error(String.valueOf(errorMsg) + e1.getMessage());
        }
        catch (InstantiationException e2) {
            throw new Error(String.valueOf(errorMsg) + e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            this.handleInvocationException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new Error(String.valueOf(errorMsg) + e4.getMessage());
        }
        this.setSSLPolicy(s);
        return s;
    }

    public Socket createSocket(InetAddress address, int port, InetAddress clientAddr, int clientPort) throws IOException {
        this.initContext();
        this.setUserIdentity();
        SSLeaySocket s = null;
        Class[] paramTypes = new Class[]{this.INETADDRESS_CLASS, Integer.TYPE, this.INETADDRESS_CLASS, Integer.TYPE, this.CONTEXT_CLASS};
        Object[] params = new Object[]{address, new Integer(port), clientAddr, new Integer(clientPort), this.context};
        String errorMsg = "SSLeaySocketFactory.createSocket(InetAddress,int,InetAddress,int):";
        try {
            s = (SSLeaySocket)this.socketType.getConstructor(paramTypes).newInstance(params);
        }
        catch (NoSuchMethodException e1) {
            throw new Error(String.valueOf(errorMsg) + e1.getMessage());
        }
        catch (InstantiationException e2) {
            throw new Error(String.valueOf(errorMsg) + e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            this.handleInvocationException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new Error(String.valueOf(errorMsg) + e4.getMessage());
        }
        this.setSSLPolicy(s);
        return s;
    }

    public String[] getDefaultCipherSuites() {
        this.initContext();
        return this.context.getDefaultCipherSuites();
    }

    public Class getSocketPrototypeClass() {
        return this.socketType;
    }

    public String[] getSupportedCipherSuites() {
        this.initContext();
        return this.context.getSupportedCipherSuites();
    }

    private void handleInvocationException(InvocationTargetException e) throws UnknownHostException, IOException {
        Throwable e1 = e.getTargetException();
        if (new IOException().getClass().isInstance(e1)) {
            throw (IOException)e1;
        }
        if (new UnknownHostException().getClass().isInstance(e1)) {
            throw (UnknownHostException)e1;
        }
        throw new Error(e1.getMessage());
    }

    private synchronized void initContext() {
        if (this.context != null) {
            return;
        }
        try {
            this.context = new SSLeaySessionContext();
        }
        catch (SSLException sSLException) {
            throw new SSLeayRuntimeException("Could not create context");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.context = null;
        this.userIdentitySet = false;
    }

    public void setDefaultCipherSuites(String[] ciphers) {
        this.initContext();
        this.context.setDefaultCipherSuites(ciphers);
    }

    protected void setSSLPolicy(SSLSocket s) throws IOException {
        s.startHandshake();
    }

    protected synchronized void setSocketPrototype(SSLeaySocket proto) {
        if (proto == null) {
            throw new IllegalArgumentException("setSocketPrototype(null)");
        }
        this.socketType = proto.getClass();
    }

    private synchronized void setUserIdentity() throws SSLeayIdentityException {
        block3: {
            if (this.userIdentitySet) {
                return;
            }
            try {
                this.context.setUserIdentity();
                this.userIdentitySet = true;
            }
            catch (SSLeayIdentityException e2) {
                String idReq = System.getProperties().getProperty("iti.ssl.clientIdentityRequired", "false");
                if (idReq.equals("false")) break block3;
                throw e2;
            }
        }
    }
}

