/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.ssl;

import de.tu_darmstadt.sp.ssl.SSLeaySessionBindingEvent;
import de.tu_darmstadt.sp.ssl.SSLeaySessionContext;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class SSLeaySession
implements SSLSession {
    protected int session;
    protected SSLeaySessionContext context;

    protected SSLeaySession(int session, SSLeaySessionContext context) {
        this.context = context;
        this.session = session;
    }

    protected synchronized native Dictionary applicationData();

    private native long doGetCreationTime();

    private native long doGetLastAccessedTime();

    protected native void doInvalidate();

    public native String getCipherSuite();

    public long getCreationTime() {
        return this.doGetCreationTime() * 1000L;
    }

    public native byte[] getId();

    public long getLastAccessedTime() {
        return this.doGetLastAccessedTime() * 1000L;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        String[] certificates = this.getPeerCertificateChainString();
        if (certificates == null) {
            certificates = new String[]{};
        }
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        try {
            int i = 0;
            while (i < certificates.length) {
                try {
                    X509Certificate obj = X509Certificate.getInstance(certificates[i].getBytes());
                    v.addElement(obj);
                }
                catch (CertificateException certificateException) {}
                ++i;
            }
        }
        catch (Exception e) {
            throw new SSLPeerUnverifiedException(e.getMessage());
        }
        X509Certificate[] result = new X509Certificate[v.size()];
        int i = 0;
        while (i < v.size()) {
            result[i] = (X509Certificate)v.elementAt(i);
            ++i;
        }
        return result;
    }

    protected native String[] getPeerCertificateChainString() throws SSLPeerUnverifiedException;

    public String getPeerHost() {
        return null;
    }

    public SSLSessionContext getSessionContext() {
        return this.context;
    }

    public Object getValue(String name) {
        return this.applicationData().get(name);
    }

    public String[] getValueNames() {
        String[] result;
        Dictionary dictionary = this.applicationData();
        synchronized (dictionary) {
            int size = this.applicationData().size();
            Enumeration enumeration = this.applicationData().keys();
            result = new String[size];
            int i = 0;
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                result[i++] = name;
            }
        }
        return result;
    }

    public void invalidate() {
        this.doInvalidate();
        this.context.update();
    }

    public void putValue(String name, Object value) {
        if (value == null || name == null) {
            throw new IllegalArgumentException();
        }
        Object object = value;
        synchronized (object) {
            this.applicationData().put(name, value);
            try {
                if (Class.forName("SSLSessionBindingListener").isInstance(value)) {
                    SSLeaySessionBindingEvent event = new SSLeaySessionBindingEvent(this, name);
                    ((SSLSessionBindingListener)value).valueBound(event);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Object value = this.applicationData().remove(name);
        try {
            if (Class.forName("SSLSessionBindingListener").isInstance(value)) {
                SSLeaySessionBindingEvent event = new SSLeaySessionBindingEvent(this, name);
                ((SSLSessionBindingListener)value).valueUnbound(event);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Cipher suite for all connections:");
        buf.append(String.valueOf(this.getCipherSuite()) + "\n");
        buf.append("Session creation time:");
        buf.append(String.valueOf(String.valueOf(new Date(this.getCreationTime()))) + "\n");
        buf.append("Certificate of the peer:\n\n");
        try {
            X509Certificate[] cert = this.getPeerCertificateChain();
            if (cert.length == 0) {
                buf.append("Peer sent no certificates\n");
            } else {
                buf.append(String.valueOf(String.valueOf(cert[0])) + "\n");
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            buf.append("Peer unverified (exception)\n");
        }
        return buf.toString();
    }
}

