/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;

public abstract class SSLSocket
extends Socket {
    protected SSLSocket() {
    }

    protected SSLSocket(String host, int port) throws UnknownHostException, IOException {
        this(InetAddress.getByName(host), port);
    }

    protected SSLSocket(String host, int port, InetAddress clientAddr, int clientPort) throws IOException {
        this(InetAddress.getByName(host), port, clientAddr, clientPort);
    }

    protected SSLSocket(InetAddress address, int port) throws IOException {
        this(address, port, null, 0);
    }

    protected SSLSocket(InetAddress address, int port, InetAddress clientAddr, int clientPort) throws IOException {
        super(address, port, clientAddr, clientPort);
    }

    public abstract void addHandshakeCompletedListener(HandshakeCompletedListener var1);

    public abstract boolean getEnableSessionCreation();

    public abstract String[] getEnabledCipherSuites();

    public abstract boolean getNeedClientAuth();

    public abstract SSLSession getSession();

    public abstract String[] getSupportedCipherSuites();

    public abstract boolean getUseClientMode();

    public abstract void removeHandshakeCompletedListener(HandshakeCompletedListener var1);

    public abstract void setEnableSessionCreation(boolean var1);

    public abstract void setEnabledCipherSuites(String[] var1) throws IllegalArgumentException;

    public abstract void setNeedClientAuth(boolean var1);

    public abstract void setUseClientMode(boolean var1);

    public abstract void startHandshake() throws IOException;
}

