// RMIServerImpl.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: RMIServerImpl.java,v 1.4 1999/02/21 14:16:43 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.example;

// used packages
import java.lang.*;
import java.rmi.*;
import java.rmi.server.*;
import de.tu_darmstadt.sp.rmi.*;
import javax.net.ssl.*;
import java.rmi.registry.*;
import java.security.*;

/**
 * Remote class RMIServerImpl provides services for RMIServer.
 *
 * @version	$Revision: 1.4 $
 * @author	Andrei Popovici
 */
public
class RMIServerImpl extends UnicastRemoteObject
  implements RMIServer
{
  static RMIServer server;
  /** Create a server object.
   *
   */
  public RMIServerImpl() throws RemoteException
  {
     super();
  }

  /** Create a server object using the specified sockets factory
    * to comunicate with the clients and listening for calls
    * on the given port; if <code>port</code> is 0, the server
    * will listen an an anonymous port.
    */
  public RMIServerImpl(int port, RMIClientSocketFactory csf,
		       RMIServerSocketFactory ssf) throws RemoteException
    {
      super(port,csf,ssf);
    }
  /** Display message <code>msg</code>. */
  public void message(String msg) throws RemoteException, Exception
    {
      // receive message
      System.err.println("Message Received:" + msg);

      // print information
      SSLSocket socket = (SSLSocket)RMISSLServerSocketFactory.getClient();
      System.err.println("CONNECTION INFORMATION");
      System.err.println(socket.toString());
    }

  /** Create amd start a server object.
    * The program expects the specification of the ca , cert and key files, either
    * in system properties or via environment variables
    *
    * This information is needed to create and istall a
    *  <code>RMISecureSocketFactory</code>. For the incomming calls, the connection
    * information (peer,cryptographic information is displayed).
    * <p>
    * The command expects one argument, <code>server-name</code>. The sever will be
    * bound to the given name at the local naming service.
    *
    * <blockquote><pre>
    * rmiserver server-name
    * </blockquote></pre>
    */
  public static
  void main( String[] args ) throws Exception
  {
    // test args
    if (args.length != 1)
      {
	System.err.println("Usage: rmiserver server-name");
	System.exit(1);
      }
    String serverName = args[0];

    // set the security manager and allow everything
    // DO NOT USE THIS IN A PRODUCTION ENVIRONMENT !!
    Policy.getPolicy().getPermissions(null).add(new AllPermission());

    // create the server, bind the server, and start..
    RMISSLServerSocketFactory ssf = new RMISSLServerSocketFactory();
    RMISSLSocketFactory csf = new RMISSLSocketFactory();

    Registry naming = (Registry)Naming.lookup("srmiregistry");

    server = new RMIServerImpl(0,csf,ssf);
    naming.rebind(serverName,server);
    System.err.println("Server " + serverName + " started");


  }

}

//======================================================================
//
// $Log: RMIServerImpl.java,v $
// Revision 1.4  1999/02/21 14:16:43  apopovic
// hardcoded identity locations removed. Runs now as a released binary
//
// Revision 1.3  1999/02/13 15:31:15  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.2  1999/02/12 08:54:41  apopovic
// Use of custom socket factories for server added
//
// Revision 1.1  1999/01/29 09:47:18  apopovic
// Initial Revision
//
