// SSLClient.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLClient.java,v 1.5 1999/02/21 14:16:57 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.example;

// used packages
import java.lang.*;
import java.io.*;
import javax.net.ssl.*;
import de.tu_darmstadt.sp.ssl.*;
import java.util.*;
/**
 * Class SSLClient is a an example on how to set up an SSLeay socket and
 * communicate with a server socket.
 * <p>
 * <code>SSLClient</code> expects 3 arguments: the host and port on
 * which the server socket listens and a message to send to the server socket.
 * The specified message will be sent to the server..
 * <p>
 * The program expects ca file, cert and key file to be specified, either via
 * properties or using environment variables.
 * <p>
 * Using this information and the commandline arguments, a conenction is established
 * to a SSLeayServerSocket. All available information about this connection is than
 * displayed.
 *
 * @version	$Revision: 1.5 $
 * @author	Andrei Popovici
 */
public
class SSLClient {

  /**
   * Start a connection to host:port, using p1.cert.pem p1.privkey.pem and cacert.pem
   * as security information and send a message to the server socket.
   * <p>
   * <blockquote><pre>
   * Usage: sslclient host port message
   * </pre></blockquote>
   */
  public static
  void main( String[] args ) throws Exception
  {
    // test the args
    if (args.length != 3)
      {
	System.err.println("usage:sslclient host port message");
	System.exit (1);
      }

    String host = args[0];
    int    port = 0;
    try
      { port = Integer.parseInt(args[1]); }
    catch (NumberFormatException e)
      {
	System.err.println("sslclient: port should be an int");
	System.exit(1);
      }
    String message = args[2];


    // NOW we can set the default system factories
    SSLSocketFactory.setDefault(new SSLeaySocketFactory());
    SSLServerSocketFactory.setDefault(new SSLeayServerSocketFactory());


    // now we can get a socket and connect..
    SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    SSLSocket socket         = (SSLSocket)factory.createSocket(host,port);

    // let's send the message to the server..
    PrintStream sockout = new PrintStream(socket.getOutputStream());
    System.err.println("Sending message to peer at host:port ->" +
		       host + ":" + port);
    System.err.println("Mesage text: "  + message);
    sockout.println(message);

    // now let's print the connections information
    System.err.println(socket);
  }



}


//======================================================================
//
// $Log: SSLClient.java,v $
// Revision 1.5  1999/02/21 14:16:57  apopovic
// hardcoded identity locations removed. Runs now as a released binary
//
// Revision 1.4  1999/02/13 15:31:15  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.3  1999/02/03 08:02:39  apopovic
// Socket factory creation (slightly) changended due to new 'getDefault' signature
//
// Revision 1.2  1999/01/29 09:50:58  apopovic
// method 'printSSLSocketInfo' removed. (now socket.toString());
//
// Revision 1.1  1999/01/27 22:14:31  apopovic
// Initial Revision
//
