// SSLServer.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLServer.java,v 1.5 1999/02/21 14:17:09 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.example;

// used packages
import java.lang.*;
import java.io.*;
import javax.net.ssl.*;
import de.tu_darmstadt.sp.ssl.*;


/**
 * Class SSLServer  is a test example showing how to setup the environment, create
 * and use a <code>SSLeayServerSocket</code>.
 * <p>
 * The program expects ca faile, cert, and key files to be specified either through
 * system properties or via environment variables.
 *
 * It also expects one argument on the ocommandline, the port to listen at;
 * <p>
 * Using this information, it creates a server socket which acceptes one connection.
 * All available SSL information is displayed for the accepted connection.
 *
 * @see de.tu_darmstadt.sp.ssl.SSLeayServerSocket
 * @see de.tu_darmstadt.sp.ssl.SSLeayServerSocketFactory
 *
 * @version	$Revision: 1.5 $
 * @author	Andrei Popovici
 */
public
class SSLServer {

  /**
   * Accept ONE connection on port; receive and display a message from
   *  the client socket.
   * <p>
   * <blockquote><pre>
   * Usage: sslserver  port
   * </pre></blockquote>
   *//**
   *
   */
  public static
  void main( String[] args ) throws Exception
  {
    // test the args
    if (args.length != 1)
      {
        System.err.println("Usage: sslserver port");
        System.exit (1);
      }

    int    port = -1;
    try
      { port = Integer.parseInt(args[0]); }
    catch (NumberFormatException e)
      {
        System.err.println("sslserver: port should be an int");
        System.exit(1);
      }

    // NOW we can set default system factories (identity information present)..
    SSLSocketFactory.setDefault(new SSLeaySocketFactory());
    SSLServerSocketFactory.setDefault(new SSLeayServerSocketFactory());



    // get a server socket and listen..
    SSLServerSocketFactory factory
      = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
    SSLServerSocket server = (SSLServerSocket)factory.createServerSocket(port);
    System.err.println("Waiting for ONE connection");
    SSLSocket server_side_socket = (SSLSocket)server.accept();

    // read the message of the client
    BufferedReader sockin = new BufferedReader
      (new InputStreamReader(server_side_socket.getInputStream()));
    System.err.println("Message received from the client:" +
		       sockin.readLine());


    // and print the connection information
    System.err.println(server_side_socket.toString());

  }

}


//======================================================================
//
// $Log: SSLServer.java,v $
// Revision 1.5  1999/02/21 14:17:09  apopovic
// hardcoded identity locations removed. Runs now as a released binary
//
// Revision 1.4  1999/02/13 15:31:15  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.3  1999/02/03 08:02:51  apopovic
// Socket factory creation (slightly) changended due to new 'getDefault' signature
//
// Revision 1.2  1999/01/29 09:52:19  apopovic
// 'printSSLSocketInfo' replaced with socket.toString()
//
// Revision 1.1  1999/01/27 22:14:31  apopovic
// Initial Revision
//
