// SecureRMIRegistry.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $ITI: SecureRMIRegistry.java,v 1.2 1999/02/01 13:49:01 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.rmi;

// used packages
import java.io.*;
import java.rmi.server.*;
import java.util.*;
import java.lang.*;
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.security.*;

/**
 * Class SecureRMIRegistry starts an RMI registry using secure
   sockets. The registration won't work if the remote servers
 * don't use secure sockets.
 *
 * @version	$ITIRevision: 1.2 $
 * @author	Andrei Popovici
 */
public
class SecureRMIRegistry {
  /**
   * Start the secure registry with one argument (port)
   */

static Registry theReg;

  /** Usage:
    * <blockquoate>
    * <pre> sslrmiregistry registry_name </pre>
    * </blockquoate>
    * Crate a new <code>de.tu_darmstadt.sp.rmi.RegistryImpl</code> server, bound to the local,
    * classical <code>rmiregistry</code> service under the the name
    * <code>registry_name</code>
    */
  public static
  void main( String[] args ) throws Exception
  {
    // test args

    if (args.length != 1)
      {
	System.err.println("usage: sslrmiregistry registry_name");
	System.exit(1);
      }

    theReg = new RegistryImpl(0);
    LogStream l = LogStream.log("tcp");
    l.setOutputStream(System.err);
    Naming.rebind(args[0],theReg);


  }
}


//======================================================================
//
// $ITIlog: SecureRMIRegistry.java,v $
// Revision 1.2  1999/02/01 13:49:01  apopovic
// Comments removed
//
// Revision 1.1  1999/01/27 22:16:10  apopovic
// Initial Revision
//
//
//
