// X509CertImpl.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: X509CertImpl.java,v 1.1 1999/02/19 14:22:22 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.security;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.security.cert.*;
import java.math.*;
import java.security.*;
/**
 * Class X509CertImpl <em>implements</em> the
 * <code>javax.security.cert.X509Certificate</code> class. The javax abstract X509
 * class extends the <code>java.security.cert.X509Certificate</code> class, so
 * this implementation transitively inherits the X509 definition of Java 2.
 * <p>
 * Fortunately, this definition matches the older javax interface.
 * <p>
 * This class is actually a wrapper arround an implementation of
 * <code>java.security.cert.X509Certificate</code>. Its
 * purpose is to create an implementation of
 * <code>javax.security.cert.X509Certificate</code>, which some applications
 * require. Simple casting an implementation of
 * <code>javax.security.cert.X509Certificate</code> wouldn't work, since the
 * class to be casted is not on the inheritance path of
 *  <code>javax.security.cert.X509Certificate</code>
 * <p>
 * <em>Note that this class is simply an implementation. Refer to the
 * SSL Reference API for interfae definition.</em>
 * @version	$Revision: 1.1 $
 * @author	Andrei Popovici
 */
public
class X509CertImpl extends javax.security.cert.X509Certificate {

  private X509Certificate impl;

  /** Create a <code>javax.security.cert</code> certificate by wrapping
    * the <code>imp</code> implementation, which is a <code>java.security.cert</code>
    * certificate
    *
   * @param impl sun's <code>java.security.cert</code> certificate
   */
  public X509CertImpl(X509Certificate impl)
  {
    this.impl = impl;
  }

  public void checkValidity()
    throws CertificateExpiredException,
    CertificateNotYetValidException
    {
      impl.checkValidity();
    }

  public  void checkValidity(Date date)
                            throws CertificateExpiredException,
                                   CertificateNotYetValidException
    {
      impl.checkValidity(date);
    }

  public int getVersion()
    {
      return impl.getVersion();
    }

  public BigInteger getSerialNumber()
    {
      return impl.getSerialNumber();
    }

  public  Principal getIssuerDN()
    {
      return impl.getIssuerDN();
    }

  public  Principal getSubjectDN()
    {
      return impl.getSubjectDN();
    }

  public  Date getNotBefore()
    {
      return impl.getNotBefore();
    }

  public Date getNotAfter()
    {
      return impl.getNotAfter();
    }

  public  byte[] getSignature()
    {
      return impl.getSignature();
    }

  public String getSigAlgName()
    {
      return impl.getSigAlgName();
    }

  public  String getSigAlgOID()
    {
      return impl.getSigAlgOID();
    }

  public  byte[] getSigAlgParams()
    {
      return impl.getSigAlgParams();
    }

  public  boolean[] getIssuerUniqueID()
    {
      return impl.getIssuerUniqueID();
    }

  public  boolean[] getSubjectUniqueID()
    {
      return impl.getSubjectUniqueID();
    }

  public  boolean[] getKeyUsage()
    {
      return impl.getKeyUsage();
    }

  public int getBasicConstraints()
    {
      return impl.getBasicConstraints();
    }

  public String toString()
    {
      return impl.toString();
    }

  public Set getCriticalExtensionOIDs()
    {
      return impl.getCriticalExtensionOIDs();
    }

  public Set getNonCriticalExtensionOIDs()
    {
      return impl.getNonCriticalExtensionOIDs();
    }

  public byte[] getEncoded()
                           throws CertificateEncodingException
    {
      return impl.getEncoded();
    }

 public void verify(PublicKey key)
                     throws CertificateException,
                            NoSuchAlgorithmException,
                            InvalidKeyException,
                            NoSuchProviderException,
                            SignatureException
    {
      impl.verify(key);
    }

  public void verify(PublicKey key,
                            String sigProvider)
                     throws CertificateException,
                            NoSuchAlgorithmException,
                            InvalidKeyException,
                            NoSuchProviderException,
                            SignatureException
    {
      impl.verify(key,sigProvider);
    }

  public  PublicKey getPublicKey()
    {
      return impl.getPublicKey();
    }
  public  byte[] getTBSCertificate()
    throws CertificateEncodingException
    {
      return impl.getTBSCertificate();
    }

  public boolean hasUnsupportedCriticalExtension()
    {
      return impl.hasUnsupportedCriticalExtension();
    }

  public byte[] getExtensionValue(String arg)
    {
      return impl.getExtensionValue(arg);
    }
}


//======================================================================
//
// $Log: X509CertImpl.java,v $
// Revision 1.1  1999/02/19 14:22:22  apopovic
// Initial Revision
//
