// ServerSocketFactory.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: ServerSocketFactory.java,v 1.2 1999/02/13 15:48:15 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package javax.net;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.net.*;

/**
 * Class ServerSocketFactory provides SUN's interface specification but adds
 * no functionality. The only implemented methods are <code>getDefault</code>
 * and <code>setDefault</code>. The <code>setDefault</code> should be used by
 * the runtime environment to set the default instance of the server factory.
 *
 * @version	$Revision: 1.2 $
 * @author	Andrei Popovici
 */
public abstract
class ServerSocketFactory  {

 static protected ServerSocketFactory defaultInstance;
  public ServerSocketFactory( )
  {

  }
  public abstract ServerSocket createServerSocket(int port)
    throws IOException;
  public abstract ServerSocket createServerSocket(int port,
                                                 int backlog)
    throws IOException;
  public abstract ServerSocket createServerSocket(int port,
                                                 int backlog,
                                                 InetAddress ifAddress)
    throws IOException;

  public static ServerSocketFactory getDefault()
    {
      return defaultInstance;
    }
  public static synchronized void setDefault(ServerSocketFactory factory)
    {
      defaultInstance = factory;
    }

    static
    {
      try
	{
	  setDefault(new de.tu_darmstadt.sp.ServerSocketFactoryImpl());
	}
      catch (Exception e)
	{
	  // if not there, we let some else set the default..
	}
    }
}


//======================================================================
//
// $Log: ServerSocketFactory.java,v $
// Revision 1.2  1999/02/13 15:48:15  apopovic
//  Package renaming iti -> de.tu-darmstadt.sp
//
// Revision 1.1  1999/02/03 07:54:29  apopovic
// Initial Revision
//
//
