// HandshakeCompletedEvent.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: HandshakeCompletedEvent.java,v 1.3 1999/02/12 13:33:03 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package javax.net.ssl;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.awt.*;
import javax.security.cert.*;

/**
 *
 * @version	$Revision: 1.3 $
 * @author	Andrei Popovici
 */
public abstract
class HandshakeCompletedEvent extends EventObject {


  /** Constructs a new HandshakeCompletedEvent.
    *
    * @param session the session used in the handshake
    * @param socket  the connection of the exception
    */
  public HandshakeCompletedEvent(SSLSocket socket, SSLSession session)
  {
    super(socket);
  }

  /**  Returns the cipher suite in use by the session which was
    *  produced by the handshake.
    */
  abstract public  String getCipherSuite();

  /** Returns the session which was produced by the handshake */
  abstract public  SSLSession getSession();

  /** Returns the socket which is the source of this event*/
  abstract public  SSLSocket getSocket();

  /** Returns the identity of the peer which was identified as part of
      defining the session. */

  abstract public X509Certificate[]
    getPeerCertificateChain() throws SSLPeerUnverifiedException;

}


//======================================================================
//
// $Log: HandshakeCompletedEvent.java,v $
// Revision 1.3  1999/02/12 13:33:03  apopovic
// Documentation rests elimninated
//
// Revision 1.2  1999/02/05 08:44:45  apopovic
// Using 'javax.security.cert' instead of 'java.securityCert'
//
// Revision 1.1  1999/01/08 10:26:11  apopovic
// Initial Revision
//
