// SSLSession.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLSession.java,v 1.3 1999/02/05 08:44:45 apopovic Exp $
// =====================================================================
//
// (history at end)
//



package javax.net.ssl;

import javax.security.cert.*;

/**
 * @version	$Revision: 1.3 $
 * @author	Andrei Popovici
 */
public
interface SSLSession {

  public
  void putValue(String name,Object value);

  public
  Object getValue(String name);

  public
  String[] getValueNames();

  public
  void removeValue(String name);

  public
  X509Certificate[] getPeerCertificateChain()
    throws SSLPeerUnverifiedException;

  public
  String getPeerHost();

  public
  SSLSessionContext getSessionContext();

  public
  byte[] getId();

  public
  long getCreationTime();

  public
  long getLastAccessedTime();

  public
  void invalidate();

  public
  String getCipherSuite();



}


//======================================================================
//
// $Log: SSLSession.java,v $
// Revision 1.3  1999/02/05 08:44:45  apopovic
// Using 'javax.security.cert' instead of 'java.securityCert'
//
// Revision 1.2  1999/01/29 15:00:43  apopovic
// Method 'getSessionContext' added
//
// Revision 1.1  1999/01/08 10:26:15  apopovic
// Initial Revision
//
