// X509Certificate.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: X509Certificate.java,v 1.2 1999/02/20 19:31:46 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package javax.security.cert;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import de.tu_darmstadt.sp.security.*;


/**
 *
 * @version	$Revision: 1.2 $
 * @author	Andrei Popovici
 */
public abstract
class X509Certificate extends  java.security.cert.X509Certificate {

public static final X509Certificate getInstance(InputStream inStream)
  throws CertificateException
    {
      java.security.cert.X509Certificate result = null;
      try
	{
	  java.security.cert.CertificateFactory fact =
	    java.security.cert.CertificateFactory.getInstance("X.509");

	  java.security.cert.X509Certificate impl =
	    (java.security.cert.X509Certificate)fact.generateCertificate(inStream);
	  result  = new X509CertImpl(impl);
	}
      catch (java.security.cert.CertificateException e)
	{ throw new CertificateException(e.getMessage()); }

      return (X509Certificate)result;

    }

  public static final X509Certificate getInstance(byte[] certData) throws CertificateException
    {
      InputStream in = new ByteArrayInputStream(certData);
      return getInstance(in);
    }



}


//======================================================================
//
// $Log: X509Certificate.java,v $
// Revision 1.2  1999/02/20 19:31:46  apopovic
// Subtle Inheritance bug fix removed: X509Cert used to extend the java 2
// X509 cert, but getInstance used to cast a sun implementation (also inheriting
// the java 2 cert) to produce a result. Now returns a de.tu_darmstadt.security
// cert implementation.
//
// Revision 1.1  1999/02/04 18:44:04  apopovic
// Initial Revision
//
