// ServerSocketFactoryImpl.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: ServerSocketFactoryImpl.java,v 1.2 1999/02/13 15:31:14 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.net.*;
import javax.net.*;

/**
 * Class ServerSocketFactory implements SUN's interface specification
 * and creates normal standard sever sockets, using the <code>ServerSocket</code>
 * constructor.
 *
 * @version	$Revision: 1.2 $
 * @author	Andrei Popovici
 */
public
class ServerSocketFactoryImpl extends ServerSocketFactory  {

 static protected ServerSocketFactory defaultInstance;
  public ServerSocketFactoryImpl( )
  {

  }

  /**
    * Returns a server socket which uses all network interfaces on the
    * host, and is bound to the specified port.
    */
  public  ServerSocket createServerSocket(int port)
    throws IOException
    {
      return new ServerSocket(port);
    }

  /** Returns a server socket which uses all network interfaces on the
    * host, is bound to a the specified port, and uses the specified
    * connection backlog.
    */

  public  ServerSocket createServerSocket(int port,
                                                 int backlog)
    throws IOException
    {
      return new ServerSocket(port,backlog);
    }

  /** Returns a server socket which uses only the specified network
    * interface on the local host, is bound to a the specified port, and
    * uses the specified connection backlog.
    */
  public ServerSocket createServerSocket(int port,
                                                 int backlog,
                                                 InetAddress ifAddress)
    throws IOException
    {
      return new ServerSocket(port,backlog,ifAddress);
    }


}


//======================================================================
//
// $Log: ServerSocketFactoryImpl.java,v $
// Revision 1.2  1999/02/13 15:31:14  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.1  1999/02/03 07:59:28  apopovic
// Initial Revision
//
//
