// SocketFactoryImpl.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SocketFactoryImpl.java,v 1.2 1999/02/13 15:31:14 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.net.*;
import javax.net.*;

/**
 * Class SocketFactory is the 'trivial' implementation for  provides Sun's interface,
 * creating common sockets, created by the <code>Socket</code> constructors.
 *
 * @version	$Revision: 1.2 $
 * @author	Andrei Popovici
 */
public
class SocketFactoryImpl  extends SocketFactory {


  public SocketFactoryImpl()
  {
  }

  /** Returns a socket connected to a ServerSocket at the specified
    * network address and port.
    */
  public Socket createSocket(String host, int port)
    throws IOException, UnknownHostException
    {
      return new Socket(host,port);
    }

  /** Returns a socket connected to a ServerSocket at the specified
    * network address and port.
    */
  public Socket createSocket(String host,
			       int port,
			       InetAddress clientHost,
			       int clientPort)
    throws IOException,UnknownHostException
    {
      return new Socket(host,port,clientHost,clientPort);
    }

  /** Returns a socket connected to a ServerSocket on the named host,
    * at the given port.
    */
  public Socket createSocket(InetAddress host,
			     int port) throws IOException
    {
      return new Socket(host,port);
    }

  /** Returns a socket connected to a ServerSocket on the named host,
    * at the given port.
    */
  public  Socket createSocket(InetAddress address,
			      int port,
			      InetAddress clientAddress,
			      int clientPort) throws IOException
    {
      return new Socket(address, port, clientAddress,clientPort);
    }
}


//======================================================================
//
// $Log: SocketFactoryImpl.java,v $
// Revision 1.2  1999/02/13 15:31:14  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.1  1999/02/03 07:59:28  apopovic
// Initial Revision
//
//
