// RMIClient.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: RMIClient.java,v 1.4 1999/02/21 14:16:26 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.example;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.rmi.*;
import java.rmi.server.*;
import de.tu_darmstadt.sp.rmi.*;
import javax.net.ssl.*;
import java.rmi.registry.*;
import java.security.*;

/**
 * Class RMIClient sends a messaga to a RMI server.
 *
 * @version	$Revision: 1.4 $
 * @author	Andrei Popovici
 */
public
class RMIClient {

  /**  Send a message to a RMIServer.
    *  The program expects the ca file, cert, and key file to be specified
    * via System properties or environment variables.
    * <p>
    * This information is needed to create and istall a
    *  <code>RMISecureSocketFactory</code>. After the call, the connection
    * information (peer,cryptographic information, etc. is displayed).
    * <p>
    * The command expects two arguments, <code>server-name</code> and
    * <code>message</code>. The sever bound to the given name
    * at the local naming service will be sent a message.
    *
    * <blockquote><pre>
    * rmiserver server-name message
    * </blockquote></pre>
    */
 public static void main(String[] args) throws Exception
    {
      if (args.length != 2)
	{
	  System.err.println("Usage: rmiclient servername message");
	  System.exit(1);
	}
      String serverName = args[0];
      String message    = args[1];


      // set socket factory and security manager
      // DO NOT USE THIS IN A PRODUCTION ENVIRONMENT !!
      Policy.getPolicy().getPermissions(null).add(new AllPermission());


      // get sever and send message
      System.err.println("Sending message (" + message +
			 ") to server " + serverName);
      Registry  sslregistry =(Registry)Naming.lookup("srmiregistry");
      RMIServer server = (RMIServer)sslregistry.lookup(serverName);
      server.message(message);

      // Display last call's info
      SSLSocket socket = RMISSLSocketFactory.getServer();
      System.err.println(socket.toString());
    }




}


//======================================================================
//
// $Log: RMIClient.java,v $
// Revision 1.4  1999/02/21 14:16:26  apopovic
// hardcoded identity locations removed. Runs now as a released binary
//
// Revision 1.3  1999/02/13 15:31:14  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.2  1999/02/12 08:53:14  apopovic
// Use of secureregisttry added
//
// Revision 1.1  1999/01/29 09:47:17  apopovic
// Initial Revision
//
