// RMIServer.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: RMIServer.java,v 1.2 1999/02/13 15:31:15 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.example;

import java.rmi.*;

/**
 * Remote interface RMIServer for a primitive RMI server accepting and
 * displaying a message.
 *
 * @version	$Revision: 1.2 $
 * @author	Andrei Popovici
 */
public
interface RMIServer extends Remote {

  /** Display message <code>msg</code>
   *
   * @param msg the message to be displayed
   */
  public
  void message(String msg) throws RemoteException,Exception;

}


//======================================================================
//
// $Log: RMIServer.java,v $
// Revision 1.2  1999/02/13 15:31:15  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.1  1999/01/29 09:47:18  apopovic
// Initial Revision
//
