// RMISSLServerSocket.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: RMISSLServerSocket.java,v 1.4 1999/02/19 14:23:33 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.rmi;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.server.*;
import de.tu_darmstadt.sp.ssl.*;

/**
 * Class RMISSLServerSocket extends <code>SSLeayServerSocket</code> by
 * creating a
 *
 * @version	$Revision: 1.4 $
 * @author	Andrei Popovici
 */
public
class RMISSLServerSocket extends SSLeayServerSocket {




  /** Every subclass of <code>SSLeayServerSocket</code> must have at least
    * its constructors. Compliance constructor.
    */
  public RMISSLServerSocket(int port, SSLeaySessionContext ctx)
    throws IOException
    {
      super(port,ctx);
      setSocketPrototype(new RMISSLSocket(ctx));
    }

  /** Every subclass of <code>SSLeayServerSocket</code> must have at least
    * its constructors. Compliance constructor.
    */
  public RMISSLServerSocket (int port, int backlog, SSLeaySessionContext ctx)
    throws IOException
    {
      super(port,backlog,ctx);
      setSocketPrototype(new RMISSLSocket(ctx));
    }

  /** Every subclass of <code>SSLeayServerSocket</code> must have at least
    * its constructors. Compliance constructor.
    */
  public
    RMISSLServerSocket(int port,int backlog,InetAddress bindAddr,SSLeaySessionContext ctx)
    throws IOException
    {
      super(port,backlog,bindAddr,ctx);
      setSocketPrototype(new RMISSLSocket(ctx));
    }

  /** Accept connection and return a connected socket. The  socket will be
    * a <code>SSLeaySocket</code>. The socket is recorded into the
    * <code>RMISSLServerSocketFactory</code>.
    */
  public Socket accept() throws IOException
    {
      Socket s = super.accept();
      return s;
    }

}


//======================================================================
//
// $Log: RMISSLServerSocket.java,v $
// Revision 1.4  1999/02/19 14:23:33  apopovic
// Initial Revision
//
// Revision 1.3  1999/02/13 15:31:16  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.2  1999/01/27 22:17:29  apopovic
// RMISSLServerSocket.java
//
// Revision 1.1  1999/01/25 08:18:47  apopovic
// Initial Revision
//
