// SSLeayHandshakeCompletedEvent.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLeayHandshakeCompletedEvent.java,v 1.3 1999/02/13 15:31:18 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.ssl;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import javax.net.ssl.*;
import javax.security.cert.*;

/**
 * Class SSLeayHandshakeCompletedEvent indicates that an SSL handshake
 * completed on a given SSL connection. All of the core information
 * about that handshake's result is captured through an "SSLSession"
 * object. As a convenience, this event class provides direct access
 * to to some important session attributes.
 *
 * @version	$Revision: 1.3 $
 * @author	Andrei Popovici
 */
public
class SSLeayHandshakeCompletedEvent extends HandshakeCompletedEvent {

  SSLeaySession session;
  SSLeaySocket  socket;

  /** Constructs a new HandshakeCompletedEvent.
    *
    * @param session the session used in the handshake
    * @param socket  the connection of the exception
    */
  public SSLeayHandshakeCompletedEvent( SSLSocket socket, SSLSession session)
  {
    super(socket,session);
    this.session = (SSLeaySession)session;
    this.socket  = (SSLeaySocket)socket;
  }

  /**  Returns the cipher suite in use by the session which was
    *  produced by the handshake.
    */
  public String getCipherSuite()
    {
      return session.getCipherSuite();
    }



  /** Returns the session which was produced by the handshake */
  public SSLSession getSession()
    {
      return session;
    }
  /** Returns the socket which is the source of this event*/
  public SSLSocket getSocket()
    {
      return socket;
    }
  /** Returns the identity of the peer which was identified as part of
      defining the session. */

  public X509Certificate[]
    getPeerCertificateChain() throws SSLPeerUnverifiedException
    {
      return session.getPeerCertificateChain();
    }


}


//======================================================================
//
// $Log: SSLeayHandshakeCompletedEvent.java,v $
// Revision 1.3  1999/02/13 15:31:18  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.2  1999/02/04 18:45:36  apopovic
// Using javax.security instead of java security
//
// Revision 1.1  1999/01/08 10:42:34  apopovic
// Initial Revision
//
