// SSLeayIdentityException.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLeayIdentityException.java,v 1.2 1999/02/13 15:31:18 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.ssl;


// used packages
import java.lang.*;
import javax.net.ssl.*;
/**
 * Exception class SSLeayIdentityException signals that XXX
 *
 * @version	$Revision: 1.2 $
 * @author	Andrei Popovici
 */
public
class SSLeayIdentityException extends SSLException {

  /**
   * Constructs an <code>SSLeayIdentityException</code> with no detail message.
   */
  public SSLeayIdentityException()
  {
    super();
  }

  /**
   * Constructs an <code>SSLeayIdentityException</code> with the specified
   * detail message.
   */
  public SSLeayIdentityException(String s)
  {
    super(s);
  }

}


//======================================================================
//
// $Log: SSLeayIdentityException.java,v $
// Revision 1.2  1999/02/13 15:31:18  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.1  1999/01/08 10:42:35  apopovic
// Initial Revision
//
