// SSLeayInputStream.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLeayInputStream.java,v 1.3 1999/02/13 15:31:18 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.ssl;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import javax.net.ssl.*;

/**
 * Class SSLeayInputStream creates an input stream based on  a
 * <code>SSLeayHandle</code>.
 *
 * @version	$Revision: 1.3 $
 * @author	Andrei Popovici
 */
public
class SSLeayInputStream extends InputStream {

  SSLeayHandle handle;

  private byte buf[] = new byte[1];     // buffer for read()

  private SSLeayInputStream() {} // no default constructor

  /** Create an Input stream which reads bytes from the given
    * <code>handle</code> representing a valid SSL connection.
    * The <code>read</code> methods can be used only
    * <em>after</em> the SSL handshake protocol on the given connection.
    *
    * @param handle the SSL peer
    */
  public SSLeayInputStream(SSLeayHandle handle)
  {
    this.handle = handle;
  }

  /**
   * Reads one byte using the three argument read.
   *
   * @return byte read
   * @exception IOException if an I/O error occurs <em>or</em> underlying
   * socket is not SSL connected (handshake not performed)
   */
  public int read() throws IOException
    {
      read( buf, 0, 1 );
      return buf[0] & 0xff;
    }

 /**
    * Reads into a byte array from underlying <code>SSL</code> socket.
    * @param b          byte array to read into
    * @param off        offset into <code>b</code>
    * @param length     number of bytes to read
    * @return           actual number of bytes read
    * @exception IOException if an I/O occurs<em>or</em> underlying
    * socket is not SSL connected (handshake not performed)
    */
  public int read( byte b[], int off, int length )
    throws IOException
    {
      int result;
      try
	{
	  result = handle.readBytes(b,off,length);
	}
      catch (IOException e)
	{
	  handle.close();
	  throw new IOException("SSL:" + e.getMessage());
	}
      return result;
    }




}


//======================================================================
//
// $Log: SSLeayInputStream.java,v $
// Revision 1.3  1999/02/13 15:31:18  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.2  1999/01/22 09:21:58  apopovic
// javax.net.ssl imports added
//
// Revision 1.1  1999/01/08 10:42:35  apopovic
// Initial Revision
//
//
