// SSLeayOutputStream.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLeayOutputStream.java,v 1.4 1999/02/13 15:31:18 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.ssl;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import javax.net.ssl.*;

/**
 * Class SSLeayOutputStream write bytes to an SSL socket. The
 * SSLeay Socket is represented by the <code>SSLeayHandle</code>
 * object. The <code>write</code> method can be envoked only
 * <em>after</em> the SSL socket represented by the given
 * handle has performed a the handshake protocol.
 *
 * @version	$Revision: 1.4 $
 * @author	Andrei Popovici
 */
public
class SSLeayOutputStream extends OutputStream{

  private SSLeayHandle handle;
  private byte buf[] = new byte[1];     // buffer for write(byte)

  /** Create a <code>SSLeayOutputStream</code> writing bytes
    * through an SSL socket denoted by the <code>SSLHandle</code>
    * parameter.
    *
    * @param handle	the handle for the underlying socket
    */
  public SSLeayOutputStream(SSLeayHandle handle)
  {
    this.handle = (SSLeayHandle)handle;
  }

  /**
    * Writes one byte using the three argument write.
    * @param b byte to write
    * @exception IOException if an I/O error occurs <em>or</em> underlying
    * socket does not have a secure connection (handshake not performed)
    */
  public void write(int b) throws IOException
    {
      buf[0] = (byte)b;
      write(buf,0,1);
    }


 /**
   * Writes an array of bytes to the underlying SSLeay Socket
   * @param b   array to write from
   * @param off offset into <code>b</code>
   * @param length number of bytes to read
   * @exception IOException if an I/O error occurs <em>or</em>
   * underlying socket has no secure connection to peer
   * (handshake not performed, uncompleted, etc.)
   */
  public
  void write( byte b[], int off, int length ) throws IOException
  {
    if (length == 0)
      return;	
    try { handle.writeBytes(b,off,length); }
    catch (SSLException e) {throw new IOException("SSL:" + e.getMessage());}
  }

}


//======================================================================
//
// $Log: SSLeayOutputStream.java,v $
// Revision 1.4  1999/02/13 15:31:18  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.3  1999/02/05 10:00:43  apopovic
// Bug fix in 'write'. Used to fail for arrays of length 0
//
// Revision 1.2  1999/01/22 09:22:21  apopovic
// javax.net.ssl imports added
//
// Revision 1.1  1999/01/08 10:42:36  apopovic
// Initial Revision
//
//
