// SSLeaySessionBindingEvent.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLeaySessionBindingEvent.java,v 1.2 1999/02/13 15:31:19 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package de.tu_darmstadt.sp.ssl;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import javax.net.ssl.*;

/**
 * Class SSLeaySessionBindingEvent communicated to a
 * SSLSessionBindingListener whenever such a listener is bound to or
 * unbound from a SSLSession value. The event's source is the
 * SSLSession to which the listener is being bound, or from which the
 *  listener is being unbound.
 *
 * @version	$Revision: 1.2 $
 * @author	Andrei Popovici
 */
public
class SSLeaySessionBindingEvent extends SSLSessionBindingEvent {

  private SSLeaySession session;
  private String        name;

  /** Constructs a new SSLSessionBindingEvent.
   *
   * @param session the session object the listener was bound to
   * @param name the name to which the listener was bound
   */
  public SSLeaySessionBindingEvent(SSLeaySession session,String name )
  {
    super(session,name);
    this.name    = name;
    this.session = session;
  }
  /** Returns the name to which the object is being bound, or the name
    * from which the object is being unbound.
    */
  public String getName()
    {
      return name;
    }
  /** Returns the SSLSession into which the listener is being bound or
    * from which the listener is being unbound.
    */
  public SSLSession getSession()
    {
      return session;
    }

}


//======================================================================
//
// $Log: SSLeaySessionBindingEvent.java,v $
// Revision 1.2  1999/02/13 15:31:19  apopovic
// pakage renaming iti -> de.tu_darmstadt.sp
//
// Revision 1.1  1999/01/08 10:42:38  apopovic
// Initial Revision
//
