// SSLServerSocket.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLServerSocket.java,v 1.1 1999/01/08 10:26:14 apopovic Exp $
// =====================================================================
//
// (history at end)
//



package javax.net.ssl;

import java.net.*;
import java.io.*;
import java.util.*;
import java.lang.*;

/**
 *
 *
 * @version	$Revision: 1.1 $
 * @author	Andrei Popovici
 */
public abstract
class SSLServerSocket  extends java.net.ServerSocket
{

  protected   SSLServerSocket(int port) throws IOException
    { super(port);}
  protected  SSLServerSocket(int port, int backlog) throws IOException
    { super(port,backlog);}

  protected  SSLServerSocket(int port, int backlog, InetAddress bindAddr)
    throws IOException
    { super(port, backlog,bindAddr);}
 abstract public void setUseClientMode(boolean mode);
 abstract public boolean getUseClientMode();
 abstract public void setNeedClientAuth(boolean flag);
 abstract public boolean getNeedClientAuth();
 abstract public String[] getSupportedCipherSuites();
 abstract public void setEnabledCipherSuites(String[] ciphers);
 abstract public String[] getEnabledCipherSuites();
 abstract public boolean getEnableSessionCreation();


}


//======================================================================
//
// $Log: SSLServerSocket.java,v $
// Revision 1.1  1999/01/08 10:26:14  apopovic
// Initial Revision
//
