// SSLServerSocketFactory.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLServerSocketFactory.java,v 1.4 1999/02/13 15:47:12 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package javax.net.ssl;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.net.*;
import javax.net.*;

/**
 * Class SSLServerSocketFactory provides SUN's interface specification but adds
 * no functionality. The only implemented methods are <code>getDefault</code>
 * and <code>setDefault</code>. The <code>setDefault</code> should be used by
 * the runtime environment to set the default instance of the server factory.
 *
 * @version	$Revision: 1.4 $
 * @author	Andrei Popovici
 */
public abstract
class SSLServerSocketFactory  extends  ServerSocketFactory {

 static protected SSLServerSocketFactory defaultInstance;
  public SSLServerSocketFactory( )
  {

  }
  public abstract ServerSocket createServerSocket(int port)
    throws IOException;
  public abstract ServerSocket createServerSocket(int port,
                                                 int backlog)
    throws IOException;
  public abstract ServerSocket createServerSocket(int port,
                                                 int backlog,
                                                 InetAddress ifAddress)
    throws IOException;
  public abstract String[] getDefaultCipherSuites();
  public abstract String[] getSupportedCipherSuites();
  public static ServerSocketFactory getDefault()
    {
      return defaultInstance;
    }
  public static synchronized void setDefault(SSLServerSocketFactory factory)
    {
      defaultInstance = factory;
    }

  static
    {
      try
	{
	  setDefault(new de.tu_darmstadt.sp.ssl.SSLeayServerSocketFactory());
	}
      catch (Exception e)
	{
	  // not there, let someone else specify the factory
	}
    }

}


//======================================================================
//
// $Log: SSLServerSocketFactory.java,v $
// Revision 1.4  1999/02/13 15:47:12  apopovic
//  Package renaming iti -> de.tu-darmstadt.sp
//
// Revision 1.3  1999/02/03 07:58:26  apopovic
// - Return type of 'getDefault' used to be incompatible with super. Fixed.
// - Default instance (de.tu_darmstadt.sp.ssl) adeed.
//
// Revision 1.2  1999/01/29 15:04:26  apopovic
// - Documentation added
// - methods 'createServerSocket' added
// - methods 'getDefault' and 'setDefault' added
//
// Revision 1.1  1999/01/08 10:26:15  apopovic
// Initial Revision
//
