// SSLSocket.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLSocket.java,v 1.2 1999/01/29 14:57:51 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package javax.net.ssl;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.net.*;

/**
 * @version	$Revision: 1.2 $
 * @author	Andrei Popovici
 */

public abstract
class SSLSocket extends Socket {


  protected  SSLSocket()
    {
      super();
    }

  protected  SSLSocket(String host, int port)
	throws UnknownHostException, IOException
    {
	this(InetAddress.getByName(host), port);
    }

  protected  SSLSocket(InetAddress address, int port) throws IOException
    {
      this(address, port, null, 0);
    }

  protected SSLSocket(String host, int port, InetAddress clientAddr,
		    int clientPort) throws IOException
    {
      this(InetAddress.getByName(host), port, clientAddr, clientPort);
    }


  protected SSLSocket(InetAddress address, int port, InetAddress clientAddr,
		  int clientPort) throws IOException
    {
      super(address, port, clientAddr, clientPort);
    };



  abstract public SSLSession getSession();

  abstract public  void setUseClientMode(boolean mode);

  abstract public boolean getUseClientMode();

  abstract public void startHandshake() throws IOException;

  abstract public boolean getNeedClientAuth();

  abstract public void setNeedClientAuth(boolean flag);

  abstract public
    void addHandshakeCompletedListener(HandshakeCompletedListener listener);

  abstract public
    void removeHandshakeCompletedListener(HandshakeCompletedListener listener);

  abstract public  String[] getSupportedCipherSuites();

  abstract public String[] getEnabledCipherSuites();

  abstract public
    void setEnabledCipherSuites(String[] ciphers) throws IllegalArgumentException;

  abstract public void setEnableSessionCreation(boolean flag);

  abstract public boolean getEnableSessionCreation();

}


//======================================================================
//
// $Log: SSLSocket.java,v $
// Revision 1.2  1999/01/29 14:57:51  apopovic
// Documentation removed
//
// Revision 1.1  1999/01/08 10:26:17  apopovic
// Initial Revision
//
//
//
