// SSLSocketFactory.java -- ITISSL Program
// ITISSL - a Java 2 implementation for Sun's reference SSL API  using SSLeay
// Copyright (C) 1999 Andrei Popovici (apopovic@iti.informatik.tu-darmstadt.de)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// he Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// $Id: SSLSocketFactory.java,v 1.4 1999/02/13 15:47:12 apopovic Exp $
// =====================================================================
//
// (history at end)
//

package javax.net.ssl;

// used packages
import java.lang.*;
import java.util.*;
import java.io.*;
import java.net.*;
import javax.net.*;

/**
 * Class SSLSocketFactory is an abstract class which provides Sun's interface,
 * but no functionality. The only implemented methods are <code>getDefault</code> and
 * <code>setDefault</code>. <code>setDefault</code> should be used by the runtime
 * environment to set the actual <code>SSLSocketFactory</code> implementation.
 *
 * @version	$Revision: 1.4 $
 * @author	Andrei Popovici
 */
public abstract
class SSLSocketFactory  extends SocketFactory {

  private static SSLSocketFactory defaultInstance;

  public SSLSocketFactory()
  {
  }
  public abstract Socket createSocket(String host, int port)
    throws IOException, UnknownHostException;
  public abstract Socket createSocket(String host,
			       int port,
			       InetAddress clientHost,
			       int clientPort)
    throws IOException,UnknownHostException;
  public abstract Socket createSocket(InetAddress host,
                                     int port) throws IOException;

  public abstract Socket createSocket(InetAddress address,
                                     int port,
                                     InetAddress clientAddress,
                                     int clientPort) throws IOException;

  public abstract String[] getDefaultCipherSuites();
  public abstract String[] getSupportedCipherSuites();
  public static SocketFactory getDefault()
    {
      return defaultInstance;
    }
  public static synchronized void setDefault(SSLSocketFactory factory)
    {
      defaultInstance = factory;
    }

  static
    {
      try
	{
	  setDefault( new de.tu_darmstadt.sp.ssl.SSLeaySocketFactory());
	}
      catch(Exception e)
	{
	  // let someone else specify the default
	}
    }
}


//======================================================================
//
// $Log: SSLSocketFactory.java,v $
// Revision 1.4  1999/02/13 15:47:12  apopovic
//  Package renaming iti -> de.tu-darmstadt.sp
//
// Revision 1.3  1999/02/03 07:57:59  apopovic
// - Return type of 'getDefault' used to be incompatible with super. Fixed.
// - Default instance (de.tu_darmstadt.sp.ssl) adeed.
//
// Revision 1.2  1999/01/29 15:06:12  apopovic
// - Documentation added
// - Methods 'createSocket' added
// - Methods 'setDefault' and 'getDefault' added.
//
// Revision 1.1  1999/01/08 10:26:17  apopovic
// Initial Revision
//
