/* stream.h - internal definiton for the STREAM object
 *        Copyright (C) 2002 Timo Schulz
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * OpenCDK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenCDK; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef CDK_STREAM_H
#define CDK_STREAM_H

enum
{
  fDUMMY     = 0,
  fARMOR     = 1,
  fCIPHER    = 2,
  fPLAINTEXT = 3,
  fCOMPRESS  = 4,
  fHASH      = 5,
  fTEXT      = 6
};

typedef int (*FILTER_FUNC) (void *opaque, FILE * in, FILE * out);

struct stream_filter_s {
  struct stream_filter_s * next;
  FILTER_FUNC fnc;
  void * opaque;
  FILE * tmp;
  union
  {
    armor_filter_s afx;
    cipher_filter_s cfx;
    plaintext_filter_s pfx;
    compress_filter_s zfx;
    text_filter_s tfx;
    md_filter_s mfx;
  } u;
  struct 
  {
    unsigned enabled:1;
    unsigned rdonly:1;
  } flags;
  unsigned type;
};


struct stream_filter_table_s
{
  int id;
  FILTER_FUNC encode;
  FILTER_FUNC decode;
};

  
struct cdk_stream_context_s
{
  struct stream_filter_s * filters;
  struct
  {
    unsigned filtrated:1;
    unsigned eof:1;
    unsigned write:1;
    unsigned temp:1;
    unsigned reset:1;
  } flags;
  struct
  {
    unsigned char buf[8192];
    unsigned on:1;
    size_t size;
  } cache;
  char * fname;
  char * tname;
  char * tmpn;
  FILE * fp;
};

#endif /* CDK_STREAM_H */
