/**
   RandomStore.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Tue Aug 17 17:51:36 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr\@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.


   $Id: RandomStore.java,v 1.4 2002/06/20 16:15:56 ekr Exp $

*/

package COM.claymoresystems.crypto;
import COM.claymoresystems.ptls.SSLDebug;

import COM.claymoresystems.cert.WrappedObject;

import java.security.SecureRandom;
import java.io.*;

public class RandomStore {
     public static SecureRandom readRandomStore(String filename,
       byte[] password)
       throws FileNotFoundException, IOException {
       SecureRandom rnd;

       FileInputStream fis=new FileInputStream(filename);
       BufferedReader br=new BufferedReader(new InputStreamReader(fis));

       if(!WrappedObject.findObject(br,"RANDOM DATA",null))
	 throw new IOException("Couldn't find randomness in this file");

       byte[] randomData=PEMData.readPEMObject(br,password);

       SSLDebug.debug(SSLDebug.DEBUG_CRYPTO,"Creating new PRNG seeded with",
         randomData);
       rnd=new SecureRandom(randomData);
       rnd.setSeed(System.currentTimeMillis()); // Make totally sure there are no repeats

       writeRandomStore(filename,password,rnd);
       
       return rnd;
     }

     public static void writeRandomStore(String filename, byte[] password,
       SecureRandom rnd)
       throws FileNotFoundException,IOException {
       FileWriter fw=new FileWriter(filename);
       BufferedWriter bw=new BufferedWriter(fw);

       byte[] rndData=new byte[1024];

       rnd.nextBytes(rndData);

       PEMData.writePEMObject(rndData,password,"RANDOM DATA",bw);

       rnd.setSeed(System.currentTimeMillis()); // Make totally sure there are no repeats
     }
}
