/**
   ClientBench.java -- client benchmark code

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu Sep  9 11:33:58 1999
*/

package COM.claymoresystems.ptls.benchmark;
import COM.claymoresystems.ptls.*;
import COM.claymoresystems.cert.*;
import COM.claymoresystems.sslg.*;
import COM.claymoresystems.util.*;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.security.SecureRandom;
import java.io.*;
import java.util.Vector;
import java.net.Socket;

class ClientBench extends SockBench{
     private void testConn(Socket s)
       throws IOException {
       try {
	 byte buf[]=new byte[4096];

	 BufferedInputStream br=new BufferedInputStream(s.getInputStream());
	 BufferedOutputStream bw=new BufferedOutputStream(s.getOutputStream());	 
         long t0=System.currentTimeMillis();
         Bench.clear();
         
	 for(int i=0;i<msgCount;i++){
	   writeMessage(bw);
           if(!noNetwork)
             readMessage(br);
	 }
         
         long t1=System.currentTimeMillis();
         long elapsed=t1-t0;

         System.out.println("Elapsed: "+t1+":"+t0+":"+elapsed);
         long total=msgCount*msgSize;
         System.out.println("Total "+total);
         long bpms=total/(t1-t0);
         long kbps=(bpms*1000)/1024;
         System.out.println("K/S="+kbps);
                                                 
	 if(exitForClose)
	   return;
         
	 if(verbose)
	   System.out.println("Closing");
	 if(!noNetwork) {
           s.close();
         }
         else{
           if(verbose)
             System.out.println("Hard close");
           ((SSLSocket)s).hardClose();
         }
       }       
       catch (SSLAlertException e){
	 throw new Error(e.toString());
       }
     }
     
     public ClientBench (String []args)
	  throws IOException {
       super("Client",args);

       try {
	 if(verbose)
	   System.out.println("Creating SSLContext");
	 SSLContext ctx=new SSLContext();
	 if(verbose)
	   System.out.println("Created SSLContext");
	 
	 ctx.loadRootCertificates(rootfile);

	 ctx.loadEAYKeyFile(keyfile,password);

	 ctx.seedRNG(null);
         SSLPolicyInt policy=new SSLPolicyInt();
         policy.acceptUnverifiableCertificates(true);
         ctx.setPolicy(policy);
         
	 while(iterate--!=0){
//	   System.out.println("Time: "+System.currentTimeMillis());
	   Socket s;

	   if(verbose)
	     System.out.println("Connecting");
	   
	   if(useNormalSockets){
	     s=new Socket(host,port);
	   }
	   else {
	     s=new SSLSocket(ctx,host,port);
             
             if(noNetwork)
               ((SSLSocket)s)._stompOutputStream((OutputStream)new NullOutputStream());
	   }
	   if(verbose)
	     System.out.println("Connected");
	   
	   testConn(s);
	   
	 }
       } catch (Exception e){
	 e.printStackTrace();
       }
     }

     public static void main(String args[])
       throws IOException {
       ClientBench cb=new ClientBench(args);

       dump();
     }
}

