/**
   DHGenerate.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Sat Dec  4 16:48:04 1999
*/



package COM.claymoresystems.ptls.demo;

import COM.claymoresystems.ptls.*;
import java.io.*;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

public class DHGenerate {

     private static void usage(){
       System.out.println("DHGenerate usage");
       System.out.println("DHGenerate -[sd] [-f file]");
       System.out.println("  -d debug mode");
       System.out.println("  -s generate Sophie-Germain primes --very slow");
       System.out.println("  -f file");
     }
     
     public static void main(String[] args)
       throws IOException {
       int c;
       boolean sg=false;
       Getopt g=new Getopt("DHGenerate",args,"sdf:");
       String file="dh.pem";

       while((c=g.getopt())!=-1)
	 switch(c){
	   case 'd':
	     SSLDebug.setDebug(SSLDebug.DEBUG_CRYPTO);
	     break;
	   case 's':
	     sg=true;
	     break;
	   case 'f':
	     file=new String(g.getOptarg());
	     break;
	   default:
	     usage();
	     return;
	 }
       
       // Make the CSJContext
       SSLContext ctx=new SSLContext();

       ctx.saveDHParams(file,1024,sg); // generate Sophie-Germain primes
     }
}
