#!/usr/local/bin/perl
sub execute_server {
  local($root,$ciphers,$key,$iterations,$additional_arg)=@_;  
  $ciph=$ciphers?"-a $ciphers":"";

  $COMMAND="java COM.claymoresystems.ptls.demo.SSLServer -f -r $root -k $key $ciph -i $iterations $additional_arg ${DEBUG_FLAGS} 2>&1 |";
  &debug("Server command $COMMAND");
  open(SERVER,$COMMAND);
  $x=<SERVER>; # Wait for the first line that shows its ready
}

sub cleanup_server {
  $SIG{ALRM}=sub {$server_err="Timed out";};
  alarm 5;
  $server_err="";

  while(<SERVER>){
    print "Server says $_\n" if $VERBOSE;
    if (/Exception/) {
      $server_err=$_;
    }
    if (/Error/){
      $server_err=$_;
    }
    $server_err.=$_ if $server_err;
  }
  alarm 0;

  &debug("Server returns $server_err");
  $server_err;
}

1; # requre fodder
