#include "general.h"

void add_proxy(char *proxy, int port, int probe) {
   struct hostent *host;

   if((host = gethostbyname2(proxy, AF_INET)) == NULL) {
      fprintf(stderr, "Add_proxy: Error resolving %s: %s\n", proxy, hstrerror(h_errno));
      exit(-1);
   }

   if(probe)
      if(probe_proxy(host->h_addr_list[0], port)) {
         if(skip_ok) {
	    err_msg("Warning %s:%d didnt respond to UDP probe", proxy, port);
            return;
         }
         else
            err_quit("Proxy %s:%d did not respond do UDP probe, exiting", proxy, port);
      }

   if(!proxyhost.s_addr) {
      memcpy(&proxyhost.s_addr, host->h_addr_list[0], 4);
      proxyport = htons(port);
      return;
   }

   if((cntrl = realloc(cntrl, (cntrl_num + 1) * sizeof(conninit))) == NULL)
      err_sys("Memory allocation error");

   memset(&cntrl[cntrl_num], 0, sizeof(conninit));

   cntrl[cntrl_num].magic = htonl(MAGIC);
   cntrl[cntrl_num].targetport = htons(port);
   memcpy(&cntrl[cntrl_num].targetip, host->h_addr_list[0], 4);
   cntrl_num++;
}

void proxy_final(void) {
   int i;

   if(cntrl_num == 1) /* Standalone mode */
      cntrl[0].control = htons(CNTRL_ALONE);
   else {
      for(i = 0; i < cntrl_num-1; i++)
         cntrl[i].control = htons(CNTRL_CHAIN);
      cntrl[cntrl_num-1].control = htons(CNTRL_ENDPO);
   }
}
