#include "general.h"

int main(int argc, char **argv) {
   int listenfd, num, i;
   fd_set rdsettmp, wrsettmp;

   listenfd = initialise(argc, argv);

   FD_ZERO(&rdset);
   FD_ZERO(&wrset);
   FD_SET(listenfd, &rdset);
   maxfd = listenfd;

   for( ; ; ) {
      rdsettmp = rdset;
      wrsettmp = wrset;

      if(debug)
         err_msg("main: in select()");

      num = select(maxfd+1, &rdsettmp, &wrsettmp, NULL, NULL);

      if(num == -1)
         if(errno == EINTR)
            continue;
         else
            err_sys("main: Select error");
      else if(num == 0)
         continue;              /* Timeout detected */

      if(debug)
         err_msg("main: selectloop: select returned %d", num);

      if(FD_ISSET(listenfd, &rdsettmp)) {
         int connfd, i;
         struct sockaddr_in cli;
         socklen_t clilen = sizeof(cli);

         if((connfd = accept(listenfd, (struct sockaddr *)&cli, &clilen)) == -1) {
            if(errno == EWOULDBLOCK || errno == ECONNABORTED)
               continue;        /* Connection was reset before we could accept */
            else
               err_sys("Accept error");
         }

         if(debug)
           err_msg("main: accepted connection from %s:%hi on fd=%d", inet_ntoa(cli.sin_addr), ntohs(cli.sin_port), connfd);

         i = Connection_add(connfd);
         Connection_connect(&conn[i]);
      }

      for(i = 0; i < conn_size; i++) {
         if(conn[i].status == ST_NOTUSED)
            continue;

	 if(FD_ISSET(conn[i].localfd, &rdsettmp)) {
	    if(IS_ST_PROCESS(conn[i]))
	       Readdata(&conn[i], FROM_LOCAL, 0);
	 }

	 if(FD_ISSET(conn[i].localfd, &wrsettmp)) {
	    if(IS_ST_PROCESS(conn[i]))
	       Writedata(&conn[i], TO_LOCAL);
	 }

         if(FD_ISSET(conn[i].remotefd, &rdsettmp)) {
            if(conn[i].status == ST_DHRECV1)
               Connection_DH_readdata(&conn[i]);
	    else if(conn[i].status == ST_DHRECV2)
	       Connection_DH_readdata(&conn[i]);
	    else if(IS_ST_PROCESS(conn[i]))
	       Readdata(&conn[i], FROM_REMOTE, 0);
         }

         if(FD_ISSET(conn[i].remotefd, &wrsettmp)) {
	    if(conn[i].status == ST_INPROGR)
 	       CheckConnection(&conn[i]);
	    else if(conn[i].status == ST_DHSEND1)
	       Connection_DH_senddata(&conn[i]);
	    else if(conn[i].status == ST_DHSEND2)
	       Connection_DH_senddata(&conn[i]);
	    else if(conn[i].status == ST_SENDINF)
	       Connection_sendinfo(&conn[i]);
	    else if(IS_ST_PROCESS(conn[i]))
	       Writedata(&conn[i], TO_REMOTE);
 	 }

      }
   }
}
