#ifndef DH_H
#define DH_H

#define DH_VAL_LEN		64
#define DH_SIGNATURE_LEN	128	/* MD5 Signature */
#define DH_DATA_LEN		DH_VAL_LEN + DH_SIGNATURE_LEN

struct DHData
{
  int server;
  unsigned char publicValue[DH_VAL_LEN];
  unsigned char privateValue[DH_VAL_LEN];
  unsigned char signature[MAX_SIGNATURE_LEN];
};

struct DHData *InitDH(R_RANDOM_STRUCT *, int, R_RSA_PRIVATE_KEY *);
int ComputeDH(unsigned char *, struct DHData *, R_RSA_PUBLIC_KEY *, unsigned char *);

#endif
