#ifndef GENERAL_H
#define GENERAL_H

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <syslog.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include "global.h"
#include "rsaref.h"
#include "init.h"
#include "base64.h"
#include "crypto.h"
#include "arcfour.h"
#include "sockatmark.h"
#include "oob_queue.h"
#include "connection.h"
#include "io.h"
#include "error.h"
#include "dh.h"

#define VERSION			"0.2"
#define LISTEN_PORT		6789	/* Default listen port	*/
#define MAX_SIMUL_CONNECT	30	/* Default upper limit on simultaneous connections	*/
#define TIMEOUT			10	/* 10 seconds time out for client to send conninit structure */
#define PRIVATE_KEY_FILE	"Server.prv"
#define PUBLIC_KEY_FILE		"Server.pub"

#define MAX(x, y)	((x) > (y) ? (x) : (y))
#define MIN(x, y)	((x) < (y) ? (x) : (y))

#ifdef SVR4
 typedef int socklen_t;
#endif

extern Connection *conn;
extern int conn_size, maxfd, debug;
extern int max_simul_con;
extern int timeout;
extern int lfd;
extern fd_set rdset, wrset;
extern int daemon_proc;
extern int sndbufsz;
extern R_RSA_PRIVATE_KEY ServerPrivateKey;

#endif
